/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;

public class PepperInterfacesCollector
implements ICElementVisitor {
    private final Pattern interfacePattern = Pattern.compile("PPB_[A-Za-z_]+");
    private final Pattern includePattern = Pattern.compile("#include\\s+\"(.*/)?(ppb_)?([\\w\\.-]+\\.h)\"");
    private final Pattern commentPattern = Pattern.compile("(//.*)|((/\\*).*?(\\*/))");
    private final Map<String, String> mapping;
    private final Set<String> interfaces;
    private boolean inBlockComment = false;

    public PepperInterfacesCollector(Map<String, String> mapping, Set<String> interfaces) {
        this.mapping = mapping;
        this.interfaces = interfaces;
    }

    public boolean visit(ICElement element) throws CoreException {
        if (element.getElementType() == 60) {
            ITranslationUnit unit = (ITranslationUnit)element;
            if (unit.getResource() == null) {
                return false;
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(unit.getResource().getLocation().toFile()));){
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ((line = this.removeComments(line)).isEmpty()) continue;
                        Matcher matcher = this.interfacePattern.matcher(line);
                        while (matcher.find()) {
                            this.interfaces.add(matcher.group());
                        }
                        matcher = this.includePattern.matcher(line);
                        while (matcher.find()) {
                            String iface = this.mapping.get(matcher.group(3));
                            if (iface == null) continue;
                            this.interfaces.add(iface);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return element.getElementType() == 12 || element.getElementType() == 11;
    }

    private String removeComments(String line) {
        Matcher matcher;
        int pos;
        if (this.inBlockComment) {
            int pos2 = line.indexOf("*/");
            if (pos2 < 0) {
                return "";
            }
            line = line.substring(pos2 + 2);
            this.inBlockComment = false;
        }
        if ((pos = (line = (matcher = this.commentPattern.matcher(line)).replaceAll("")).indexOf("/*")) >= 0) {
            line = line.substring(0, pos);
            this.inBlockComment = true;
        }
        return line;
    }
}

