/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.io.File;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.builder.toolchain.Messages;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.IToolchain;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ToolchainManagerUi;

public class ToolchainPage
extends PropertyPage {
    private ToolchainManagerUi ui = new ToolchainManagerUi();
    private IToolchain selectedToolchain = null;

    public ToolchainPage() {
        this.ui.setEnableToolchainConfirmation((Consumer)new Consumer<Boolean>(){

            @Override
            public void accept(Boolean valid) {
                ToolchainPage.this.setValid(valid);
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.createToolchainControls(comp, project);
        return comp;
    }

    private void createToolchainControls(Composite comp, IProject project) {
        this.ui.createContents(comp);
        this.setInitialToolchainValues(project);
    }

    private void setInitialToolchainValues(IProject project) {
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        Preferences projectPrefs = prefs.getProjectPreferences(project);
        String currentPepper = projectPrefs.get("pepperVersion", "");
        String name = new File(currentPepper).getName();
        this.ui.setSelectedToolchain(name);
        this.selectedToolchain = this.ui.getSelectedToolchain();
    }

    public boolean performOk() {
        final IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        final Preferences projectPrefs = prefs.getProjectPreferences(project);
        this.selectedToolchain = this.ui.getSelectedToolchain();
        projectPrefs.putBoolean("customPepperPath", true);
        projectPrefs.put("pepperVersion", this.selectedToolchain.getPath().getAbsolutePath());
        Job job = new Job(Messages.ToolchainPage_JobName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    projectPrefs.flush();
                    project.build(15, monitor);
                    project.close(monitor);
                    project.open(monitor);
                }
                catch (BackingStoreException ex) {
                    MessageDialog.openError((Shell)ToolchainPage.this.getShell(), (String)Messages.ToolchainPage_saveError, (String)ex.getLocalizedMessage());
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException ex) {
                    Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    public void dispose() {
        try {
            this.ui.cancelVerification();
        }
        catch (InterruptedException | OperationCanceledException e) {
            System.err.println("Failed to cancel the toolchain's verification: " + e);
        }
        super.dispose();
    }
}

