/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.project_wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.tizen.web.tv.sec.nacl.common.FileToCopy;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.mtgenerator.ISourceGenerator;
import org.tizen.web.tv.sec.nacl.mtgenerator.JsMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.Message;
import org.tizen.web.tv.sec.nacl.mtgenerator.MessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.NaClMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.SimpleMessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.SourceGenerator;
import org.tizen.web.tv.sec.nacl.project_wizards.Messages;
import org.tizen.web.tv.sec.nacl.project_wizards.PNaClProjectProvider;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;

public class CreateProjectTemplate
extends PNaClProjectProvider {
    private final Map<PluginConfig.ETemplateInterfaces, Collection<Message>> interfaceMessages;
    private final String responseSuffix = "Response";
    private final MessageData paramCode = new SimpleMessageData("code", SimpleMessageData.Type.Int.toString(), "Zero if succeed, otherwise an error code from pp_errors.h.");
    private final String communicationJS = "communication.js";

    public CreateProjectTemplate(IProgressMonitor monitor) {
        this.progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating project template", (int)100);
        this.interfaceMessages = new HashMap<PluginConfig.ETemplateInterfaces, Collection<Message>>();
        this.prepareAudioTemplate();
        this.prepareTCPSocketTemplate();
        this.prepareUDPSocketTemplate();
        this.prepareURLLoaderTemplate();
        this.prepareFileIOTemplate();
        this.prepareMouseCursorTemplate();
        this.prepareMouseLockTemplate();
    }

    private String generateMessages(List<PluginConfig.ETemplateInterfaces> chosenInterfaces, String javaScriptCodePath, String naclCodePath, NativeLanguage lang, String[] includeSearchPaths) {
        String packageName = SourceGenerator.class.getPackage().getName();
        String logFilePath = "%t/" + packageName + System.getProperty("user.name") + "_%g.log";
        SourceGenerator sourceGenerator = new SourceGenerator(logFilePath, Level.WARNING);
        for (PluginConfig.ETemplateInterfaces einterface : chosenInterfaces) {
            Collection<Message> messages = this.interfaceMessages.get((Object)einterface);
            if (messages == null) {
                String ret = NLS.bind((String)Messages.CreateProjectTemplate_NotFoundMessages, (Object)einterface.toString());
                Logger.getGlobal().severe(ret);
                return ret;
            }
            ISourceGenerator.Result result = sourceGenerator.addMessages(javaScriptCodePath, naclCodePath, includeSearchPaths, lang, "nacl_module", messages, null);
            if (result == ISourceGenerator.Result.Success) continue;
            String text = "Failed to generate messages for " + einterface.toString() + " interface.\n" + "Error: " + result.toString();
            Logger.getGlobal().severe(text);
            return result.toString();
        }
        return "";
    }

    @Override
    protected boolean getFilesToCopy(ProjectData projectData, List<FileToCopy> filesOut) {
        return PluginConfig.getInstance().getEmptyProjectFiles(projectData.basicProjectInfo.language, filesOut);
    }

    private void prepareAudioTemplate() {
        ArrayList<JsMessage> listMessages = new ArrayList<JsMessage>();
        String funcName = "StartPlayback";
        JsMessage message = new JsMessage("audio" + funcName, new TreeSet());
        listMessages.add(message);
        TreeSet<MessageData> msgParams = new TreeSet<MessageData>();
        msgParams.add(this.paramCode);
        message = new NaClMessage("audio" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "StopPlayback";
        message = new JsMessage("audio" + funcName, new TreeSet());
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("audio" + funcName + "Response", msgParams);
        listMessages.add(message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.AUDIO, listMessages);
    }

    private void prepareFileIOTemplate() {
        ArrayList<JsMessage> listMessages = new ArrayList<JsMessage>();
        String funcName = "Open";
        TreeSet<Object> msgParams = new TreeSet<Object>();
        msgParams.add(new SimpleMessageData("fileName", SimpleMessageData.Type.String.toString(), "File name with path."));
        msgParams.add(new SimpleMessageData("fileSystemType", SimpleMessageData.Type.Int.toString(), "A file system type as defined by PP_FileSystemType enum."));
        msgParams.add(new SimpleMessageData("openFlags", SimpleMessageData.Type.Int.toString(), "A bit-mask of the PP_FileOpenFlags values."));
        JsMessage message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Query";
        msgParams = new TreeSet();
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("size", SimpleMessageData.Type.Int.toString(), "This value represents the size of the file measured in bytes."));
        msgParams.add(new SimpleMessageData("type", SimpleMessageData.Type.Int.toString(), "This value represents the type of file as defined by the PP_FileType enum."));
        msgParams.add(new SimpleMessageData("systemType", SimpleMessageData.Type.Int.toString(), "This value represents the file system type of the file as defined by the PP_FileSystemType enum."));
        msgParams.add(new SimpleMessageData("creationTime", SimpleMessageData.Type.Double.toString(), "This value represents the creation time of the file (epoch time defined as PP_Time)."));
        msgParams.add(new SimpleMessageData("lastAccessTime", SimpleMessageData.Type.Double.toString(), "This value represents the last time the file was accessed (epoch time defined as PP_Time)."));
        msgParams.add(new SimpleMessageData("lastModifiedTime", SimpleMessageData.Type.Double.toString(), "This value represents the last time the file was modified (epoch time defined as PP_Time)."));
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Touch";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("lastAccessTime", SimpleMessageData.Type.Double.toString(), "This value represents the last time the file was accessed (Epoch time defined as PP_Time)."));
        msgParams.add(new SimpleMessageData("lastModifiedTime", SimpleMessageData.Type.Double.toString(), "This value represents the last time the file was modified (Epoch time defined as PP_Time)."));
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Read";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("offset", SimpleMessageData.Type.Int.toString(), "The offset into the file."));
        msgParams.add(new SimpleMessageData("bytesToRead", SimpleMessageData.Type.Int.toString(), "The number of bytes to read from offset."));
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Read file content."));
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Write";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("offset", SimpleMessageData.Type.Int.toString(), "The offset into the file."));
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "The buffer to hold the specified number of bytes read."));
        msgParams.add(new SimpleMessageData("bytesToWrite", SimpleMessageData.Type.Int.toString(), "The number of bytes to write to offset."));
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Read file content."));
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "SetLength";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("length", SimpleMessageData.Type.Int.toString(), "The length of the file to be set."));
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Flush";
        msgParams = new TreeSet();
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("fileIO" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "Close";
        msgParams = new TreeSet();
        message = new JsMessage("fileIO" + funcName, msgParams);
        listMessages.add(message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.FILE_IO, listMessages);
    }

    @Override
    protected String prepareForProjectType(ProjectData projectData) {
        String retError = "";
        String jsPath = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + "scripts" + File.separator + "project.js";
        if (this.prepareProjectJs(projectData, this.getNmfPath(projectData), jsPath)) {
            String[] stringArray;
            String javaScriptComunication = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + "scripts" + File.separator + "communication.js";
            String pluginSrc = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + projectData.contentData.sourceFilePath;
            if (projectData.contentData.headerFilePath != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ProjectUtils.getProjectByName((String)projectData.basicProjectInfo.projectName).getLocation().append(new File(projectData.contentData.headerFilePath).getParent()).toOSString();
            } else {
                stringArray = new String[]{};
            }
            String[] includeSearchPaths = stringArray;
            retError = this.generateMessages(projectData.contentData.listTemplates, javaScriptComunication, pluginSrc, projectData.basicProjectInfo.language, includeSearchPaths);
        } else {
            retError = Messages.CreateProjectTemplate_FailedToGenJS;
        }
        return retError;
    }

    private void prepareMouseCursorTemplate() {
        ArrayList<JsMessage> listMessages = new ArrayList<JsMessage>();
        String funcName = "SetCursor";
        TreeSet<SimpleMessageData> msgParams = new TreeSet<SimpleMessageData>();
        msgParams.add(new SimpleMessageData("cursorType", SimpleMessageData.Type.Int.toString(), "A PP_MouseCursor_Type identifying the type of mouse cursor to show. See ppapi/c/ppb_mouse_cursor.h."));
        JsMessage message = new JsMessage("mouseCursor" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("isSucceed", SimpleMessageData.Type.Int.toString(), "True on success, or false if the instance or cursor type was invalid."));
        message = new NaClMessage("mouseCursor" + funcName + "Response", msgParams);
        listMessages.add(message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.MOUSE_CURSOR, listMessages);
    }

    private void prepareMouseLockTemplate() {
        ArrayList<JsMessage> listMessages = new ArrayList<JsMessage>();
        String funcName = "LockMouse";
        TreeSet<MessageData> msgParams = new TreeSet<MessageData>();
        JsMessage message = new JsMessage("mouseLock" + funcName, msgParams);
        listMessages.add(message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("mouseLock" + funcName + "Response", msgParams);
        listMessages.add(message);
        funcName = "UnlockMouse";
        msgParams = new TreeSet();
        message = new JsMessage("mouseLock" + funcName, msgParams);
        listMessages.add(message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.MOUSE_LOCK, listMessages);
    }

    private void prepareTCPSocketTemplate() {
        ArrayList<Message> listMessages = new ArrayList<Message>();
        String funcName = "GetLocalAddress";
        TreeSet<Object> msgParams = new TreeSet<Object>();
        msgParams.add(new SimpleMessageData("withPort", SimpleMessageData.Type.Bool.toString(), "Set true if address should contain port as [:port_num]"));
        msgParams.add(new SimpleMessageData("asIPv6", SimpleMessageData.Type.Bool.toString(), "Set true if should get IPv6 address, otherwise will return IPv4."));
        JsMessage message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "Network address with optional port number as host[:port_num]"));
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "GetRemoteAddress";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("withPort", SimpleMessageData.Type.Bool.toString(), "Set true if address should contain port as :<port_num>"));
        msgParams.add(new SimpleMessageData("asIPv6", SimpleMessageData.Type.Bool.toString(), "Set true if should get IPv6 address, otherwise will return IPv4."));
        message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "Network address with optional port number as host[:port_num]"));
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Bind";
        this.usePredefinedSocket(listMessages, funcName, "tcpSocket");
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Connect";
        this.usePredefinedSocket(listMessages, funcName, "tcpSocket");
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Read";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("bytesToRead", SimpleMessageData.Type.Int.toString(), "Number of bytes to read."));
        message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Buffer with read data."));
        msgParams.add(new SimpleMessageData("bytesRead", SimpleMessageData.Type.Int.toString(), "The number of bytes to read."));
        msgParams.add(new SimpleMessageData("code", SimpleMessageData.Type.Int.toString(), "A non-negative number on success to indicate how many bytes have been read, 0 means that end-of-file was reached; otherwise, an error code from pp_errors.h"));
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Write";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("bytesToSend", SimpleMessageData.Type.Int.toString(), "Number of bytes to send."));
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Buffer with data to send."));
        message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("code", SimpleMessageData.Type.Int.toString(), "A non-negative number on success to indicate how many bytes have been written; otherwise, an error code from pp_errors.h."));
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Listen";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("backlog", SimpleMessageData.Type.Int.toString(), "A hint to determine the maximum length to which the queue of pending connections may grow."));
        message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Accept";
        msgParams = new TreeSet();
        message = new JsMessage("tcpSocket" + funcName, null);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "An address of accepted connection as host:port."));
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Close";
        msgParams = new TreeSet();
        message = new JsMessage("tcpSocket" + funcName, null);
        listMessages.add((Message)message);
        funcName = "SetOption";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("option", SimpleMessageData.Type.Int.toString(), "The option to set. Please see the PP_TCPSocket_Option description for option names, value types and allowed values."));
        msgParams.add(new SimpleMessageData("value", SimpleMessageData.Type.String.toString(), "The option value to set."));
        message = new JsMessage("tcpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("tcpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.TCP_SOCKET, listMessages);
    }

    private void prepareUDPSocketTemplate() {
        ArrayList<Message> listMessages = new ArrayList<Message>();
        String funcName = "Bind";
        this.usePredefinedSocket(listMessages, funcName, "udpSocket");
        TreeSet<Object> msgParams = new TreeSet<Object>();
        msgParams.add(this.paramCode);
        NaClMessage message = new NaClMessage("udpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "GetBoundAddress";
        msgParams = new TreeSet();
        message = new JsMessage("udpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "Network address with port number as host:port_num"));
        message = new NaClMessage("udpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "RecvFrom";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("bytesToRead", SimpleMessageData.Type.Int.toString(), "Number of bytes to read."));
        message = new JsMessage("udpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Buffer with read data."));
        msgParams.add(new SimpleMessageData("bytesRead", SimpleMessageData.Type.Int.toString(), "The number of bytes to receive."));
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "Network address from which data was sent with port number as host:port_num."));
        msgParams.add(new SimpleMessageData("code", SimpleMessageData.Type.Int.toString(), "A non-negative number on success to indicate how many bytes have been received; otherwise, an error code from pp_errors.h"));
        message = new NaClMessage("udpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "SendTo";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("buffer", SimpleMessageData.Type.ArrayBuffer.toString(), "Buffer with data to send."));
        msgParams.add(new SimpleMessageData("bytesToSend", SimpleMessageData.Type.Int.toString(), "Number of bytes to send."));
        msgParams.add(new SimpleMessageData("address", SimpleMessageData.Type.String.toString(), "Network address with port number as host:port_num for which data should be send."));
        message = new JsMessage("udpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("code", SimpleMessageData.Type.Int.toString(), "A non-negative number on success to indicate how many bytes have been written; otherwise, an error code from pp_errors.h."));
        message = new NaClMessage("udpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        funcName = "Close";
        msgParams = new TreeSet();
        message = new JsMessage("udpSocket" + funcName, null);
        listMessages.add((Message)message);
        funcName = "SetOption";
        msgParams = new TreeSet();
        msgParams.add(new SimpleMessageData("option", SimpleMessageData.Type.Int.toString(), "The option to set. Please see the PP_UDPSocket_Option description for option names, value types and allowed values."));
        msgParams.add(new SimpleMessageData("value", SimpleMessageData.Type.String.toString(), "The option value to set."));
        message = new JsMessage("udpSocket" + funcName, msgParams);
        listMessages.add((Message)message);
        msgParams = new TreeSet();
        msgParams.add(this.paramCode);
        message = new NaClMessage("udpSocket" + funcName + "Response", msgParams);
        listMessages.add((Message)message);
        this.interfaceMessages.put(PluginConfig.ETemplateInterfaces.UDP_SOCKET, listMessages);
    }

    private void prepareURLLoaderTemplate() {
    }

    protected void usePredefinedSocket(Collection<Message> listMessages, String funcName, String interfacePrefix) {
        TreeSet<SimpleMessageData> msgParams = new TreeSet<SimpleMessageData>();
        msgParams.add(new SimpleMessageData("host", SimpleMessageData.Type.String.toString(), "Host name or IP address"));
        msgParams.add(new SimpleMessageData("port", SimpleMessageData.Type.Int.toString(), "Port number from 0 to 65535."));
        JsMessage message = new JsMessage(String.valueOf(interfacePrefix) + funcName, msgParams);
        listMessages.add((Message)message);
    }
}

