/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.IToolchain;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.NaClToolchain;

public class NaClToolchainsManager {
    private static final String TOOLCHAINS_NODE_NAME = "toolchains";
    private static final String NAME_NODE_NAME = "name";
    private static final String URL_NODE_NAME = "url";
    private static final String VERSION_NODE_NAME = "version";
    private static final String HASH_NODE_NAME = "hash";
    private URL listUrl;
    private File targetPath;
    private final Map<String, NaClToolchain> toolchains = new TreeMap<String, NaClToolchain>();
    private IToolchain selectedToolchain = null;
    private boolean initializedFromUrl;

    public void initialize(URL toolchainsListUrl, String toolchainsTargetPath) throws NaClToolchain.UpdateFailure, IOException {
        this.targetPath = new File(toolchainsTargetPath);
        this.initializedFromUrl = false;
        this.toolchains.clear();
        this.initializeFromTargetDirectory();
        if (toolchainsListUrl == null) {
            throw new IOException("Failed to retrieve the toolchains list from empty url (SHS failure?)");
        }
        this.initializeFromList(toolchainsListUrl);
    }

    public Map<String, NaClToolchain> getToolchains() {
        return this.toolchains;
    }

    public void putToolchainsIntoTable(Table table) {
        try {
            Iterator<NaClToolchain> iterator = this.toolchains.values().iterator();
            table.removeAll();
            while (iterator.hasNext()) {
                IToolchain toolchain = iterator.next();
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{toolchain.getName(), toolchain.getStatus().toString(), toolchain.getStatus() != NaClToolchain.Status.NOT_INSTALLED ? toolchain.getPath().toString() : ""});
                if (!toolchain.equals(this.getSelectedToolchain())) continue;
                table.setSelection(item);
            }
        }
        catch (SWTException sWTException) {
            return;
        }
    }

    public void setSelectedToolchain(IToolchain toolchain) {
        this.selectedToolchain = null;
        if (this.toolchains.containsKey(toolchain.getName())) {
            this.selectedToolchain = this.toolchains.get(toolchain.getName());
        }
    }

    public IToolchain getSelectedToolchain() {
        if (this.selectedToolchain != null && this.toolchains.containsKey(this.selectedToolchain.getName())) {
            return this.toolchains.get(this.selectedToolchain.getName());
        }
        return null;
    }

    public boolean isInitializedFromUrl() {
        return this.initializedFromUrl;
    }

    public boolean shouldEnableTargetPathChange() {
        for (IToolchain iToolchain : this.toolchains.values()) {
            switch (iToolchain.getStatus()) {
                case INSTALLING: 
                case REMOVING: 
                case VERYFING: {
                    return false;
                }
            }
        }
        return true;
    }

    private void initializeFromTargetDirectory() throws NaClToolchain.UpdateFailure {
        File[] toolchainsDirs = this.targetPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("pepper_");
            }
        });
        if (toolchainsDirs == null) {
            return;
        }
        File[] fileArray = toolchainsDirs;
        int n = toolchainsDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File toolchainDir = fileArray[n2];
            String name = toolchainDir.getName();
            String version = NaClToolchain.getInstalledVersion(name, toolchainDir);
            if (this.toolchains.containsKey(name)) {
                this.toolchains.get(name).update("", version != null ? version : "_", this.targetPath.getAbsolutePath(), "");
            } else {
                this.toolchains.put(name, new NaClToolchain(name, "", version, this.targetPath.getAbsolutePath(), ""));
            }
            ++n2;
        }
        this.initializedFromUrl = false;
    }

    private void initializeFromList(URL toolchainsListUrl) throws NaClToolchain.UpdateFailure, IOException {
        JsonNode root;
        block15: {
            this.listUrl = toolchainsListUrl;
            ObjectMapper mapper = new ObjectMapper();
            root = null;
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream stream = this.listUrl.openStream();){
                root = mapper.readTree(stream);
                if (root != null) break block15;
                return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        JsonNode toolchainsNode = root.get(TOOLCHAINS_NODE_NAME);
        if (toolchainsNode == null) {
            return;
        }
        Iterator iterator = ((ArrayNode)toolchainsNode).elements();
        while (iterator.hasNext()) {
            JsonNode toolchain = (JsonNode)iterator.next();
            try {
                String name = NaClToolchainsManager.getJsonNodeValue(toolchain, NAME_NODE_NAME);
                if (this.toolchains.containsKey(name)) {
                    this.toolchains.get(name).update(NaClToolchainsManager.getJsonNodeValue(toolchain, URL_NODE_NAME), NaClToolchainsManager.getJsonNodeValue(toolchain, VERSION_NODE_NAME), this.targetPath.getAbsolutePath(), NaClToolchainsManager.getJsonNodeValue(toolchain, HASH_NODE_NAME));
                    continue;
                }
                this.toolchains.put(name, new NaClToolchain(name, NaClToolchainsManager.getJsonNodeValue(toolchain, URL_NODE_NAME), NaClToolchainsManager.getJsonNodeValue(toolchain, VERSION_NODE_NAME), this.targetPath.getAbsolutePath(), NaClToolchainsManager.getJsonNodeValue(toolchain, HASH_NODE_NAME)));
            }
            catch (JsonNodeNotFound e) {
                e.printStackTrace();
            }
        }
        this.initializedFromUrl = true;
    }

    public static String getJsonNodeValue(JsonNode parent, String name) throws JsonNodeNotFound {
        JsonNode node = parent.get(name);
        if (node == null) {
            throw new JsonNodeNotFound(name);
        }
        return node.textValue();
    }

    public static class JsonNodeNotFound
    extends Exception {
        private static final long serialVersionUID = -304439643355125394L;

        public JsonNodeNotFound(String message) {
            super(message);
        }
    }
}

