/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.tizen.web.tv.sec.nacl.common.GeneralTools;

public class ToolchainVerifier {
    private static final int BUFFER_SIZE = 8192;
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final char SEPARATOR = '/';
    private static final Set<String> FILE_EXTENSIONS_TO_SKIP = Stream.of("pyc", "pyo", "pyd").collect(Collectors.toSet());
    private static final Set<String> FILE_NAMES_TO_SKIP = Stream.of(".version").collect(Collectors.toSet());
    private final Map<String, String> dirFilesHashes = new TreeMap<String, String>();
    private File initialDirectory = null;

    private String calculateTopChecksumInDir(File directory, IProgressMonitor monitor) throws IOException, NoSuchAlgorithmException {
        this.dirFilesHashes.clear();
        this.initialDirectory = directory;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Md5SumVisitor visitor = new Md5SumVisitor((IProgressMonitor)progress.split(90));
        Files.walkFileTree(this.initialDirectory.toPath(), visitor);
        return visitor.getTopChecksum((IProgressMonitor)progress.split(10));
    }

    public boolean verify(String originalHash, File toolchainDirectory, IProgressMonitor monitor) throws IOException, NoSuchAlgorithmException {
        String hash = this.calculateTopChecksumInDir(toolchainDirectory, monitor);
        return hash.equals(originalHash);
    }

    private static String makePathOsAgnostic(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        return path.replace(File.separatorChar, '/');
    }

    private static String md5sum(InputStream stream) throws NoSuchAlgorithmException, IOException {
        return ToolchainVerifier.md5sum(stream, 8192);
    }

    private static String md5sum(InputStream stream, int readBufferLength) throws NoSuchAlgorithmException, IOException {
        byte[] buffer = new byte[readBufferLength];
        MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
        int read = 0;
        while ((read = stream.read(buffer)) != -1) {
            md.update(buffer, 0, read);
        }
        return ToolchainVerifier.bytesToHexString(md.digest());
    }

    private static String md5sum(String data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
        md.update(data.getBytes());
        return ToolchainVerifier.bytesToHexString(md.digest());
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b & 0xFF));
            ++n2;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: Checksum <hash> <directory_to_check>");
            return;
        }
        try {
            ToolchainVerifier ck = new ToolchainVerifier();
            System.out.println(ck.verify(args[0], new File(args[1]), (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private class Md5SumVisitor
    extends SimpleFileVisitor<Path> {
        private final SubMonitor progress;

        public Md5SumVisitor(IProgressMonitor monitor) throws IOException {
            FilesCounter counter = new FilesCounter();
            Files.walk(ToolchainVerifier.this.initialDirectory.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(counter);
            this.progress = SubMonitor.convert((IProgressMonitor)monitor, (int)counter.getFilesCount());
            this.progress.setTaskName("Calculating checksums");
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.progress.isCanceled()) {
                return FileVisitResult.TERMINATE;
            }
            this.progress.split(1);
            String fileName = file.getFileName().toString();
            if (FILE_EXTENSIONS_TO_SKIP.contains(GeneralTools.getFileExtension((String)fileName)) || FILE_NAMES_TO_SKIP.contains(fileName)) {
                return FileVisitResult.CONTINUE;
            }
            String relativePath = ToolchainVerifier.this.initialDirectory.toPath().getParent().relativize(file).toString();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fileStream = new FileInputStream(file.toFile());){
                    ToolchainVerifier.this.dirFilesHashes.put(ToolchainVerifier.makePathOsAgnostic(relativePath), ToolchainVerifier.md5sum(fileStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
            if (this.progress.isCanceled()) {
                return FileVisitResult.TERMINATE;
            }
            if (ex == null) {
                return FileVisitResult.CONTINUE;
            }
            throw ex;
        }

        public String getTopChecksum(IProgressMonitor monitor) throws NoSuchAlgorithmException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ToolchainVerifier.this.dirFilesHashes.size());
            progress.setTaskName("Calculating the top checksum");
            StringBuilder sb = new StringBuilder();
            for (String hash : ToolchainVerifier.this.dirFilesHashes.values()) {
                sb.append(hash);
                progress.worked(1);
            }
            return ToolchainVerifier.md5sum(sb.toString());
        }

        private class FilesCounter
        implements Consumer<Path> {
            private int counter = 0;

            private FilesCounter() {
            }

            @Override
            public void accept(Path path) {
                ++this.counter;
            }

            public int getFilesCount() {
                return this.counter;
            }
        }
    }
}

