/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IProject;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;

public class NaClModuleBinariesFilter
implements FileFilter {
    private final String moduleBasePath;
    private final String moduleBinPath;

    public NaClModuleBinariesFilter(IProject naclModule) {
        this.moduleBasePath = NaClModuleUtils.getNaClModuleBasePath((IProject)naclModule);
        this.moduleBinPath = NaClModuleUtils.getNaClModuleCurrentBinPath((IProject)naclModule);
    }

    @Override
    public boolean accept(File pathname) {
        String path = pathname.getAbsolutePath();
        return path.equals(this.moduleBasePath) || path.equals(this.moduleBinPath) || NaClModuleBinariesFilter.isInLibArmDirectory(this.moduleBinPath, path) || NaClModuleBinariesFilter.isNmfOrNexeFile(this.moduleBinPath, path);
    }

    private static boolean isInLibArmDirectory(String naclModuleBinPath, String absoluteFilePath) {
        return absoluteFilePath.startsWith(String.valueOf(naclModuleBinPath) + File.separator + "libarm");
    }

    private static boolean isNmfOrNexeFile(String naclModuleBinPath, String absoluteFilePath) {
        return absoluteFilePath.startsWith(naclModuleBinPath) && (absoluteFilePath.endsWith(".nexe") || absoluteFilePath.endsWith(".nmf"));
    }
}

