/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.wizards;

import java.awt.Point;
import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools.NaClModuleInserter;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.Messages;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.NaclNameWizardPage;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.NaclSizeWizardPage;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.NaclTemplateWizardPage;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.project_wizards.PNaClProjectProvider;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;
import org.tizen.web.tv.sec.nacl.project_wizards.ResultReporter;

public class NaClModuleWizard
extends Wizard
implements INewWizard {
    public static final String DEFAULT_WIZARD_PAGE_NAME = "wizardPage";
    private NaclTemplateWizardPage templatePage;
    private NaclSizeWizardPage sizePage;
    private NaclNameWizardPage namePage;
    private ISelection selection;
    private IProject project;
    private String errorMessage;
    private final IPageChangedListener listener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent arg0) {
            if (arg0.getSelectedPage() == NaClModuleWizard.this.sizePage) {
                NaClModuleWizard.this.sizePage.actionOnSampleChange(((NaClModuleWizard)NaClModuleWizard.this).templatePage.getData().projectType.equals(ProjectData.ProjectType.Example.toString()));
            } else if (arg0.getSelectedPage() == NaClModuleWizard.this.namePage) {
                NaClModuleWizard.this.namePage.actionOnSampleChange(((NaClModuleWizard)NaClModuleWizard.this).templatePage.getData().projectType.equals(ProjectData.ProjectType.Example.toString()));
                NaClModuleWizard.this.namePage.updateModuleFilesPaths(((NaClModuleWizard)NaClModuleWizard.this).templatePage.getData().language, true);
            }
        }
    };

    public NaClModuleWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("NaCl Module Wizard");
    }

    public void addPages() {
        this.sizePage = new NaclSizeWizardPage();
        this.templatePage = new NaclTemplateWizardPage();
        this.namePage = new NaclNameWizardPage(this.selection);
        this.addPage((IWizardPage)this.templatePage);
        this.addPage((IWizardPage)this.namePage);
        this.addPage((IWizardPage)this.sizePage);
    }

    public boolean canFinish() {
        return this.sizePage.isCurrentPage();
    }

    public void setNamePage(NaclNameWizardPage namePage) {
        this.namePage = namePage;
    }

    public boolean performFinish() {
        NaclNameWizardPage.Data nameData = this.namePage.getData();
        NaclTemplateWizardPage.Data templateData = this.templatePage.getData();
        ProjectData projectData = new ProjectData();
        projectData.basicProjectInfo.hasToolchainPath = false;
        projectData.basicProjectInfo.itsDefaultPath = false;
        projectData.basicProjectInfo.language = templateData.language.equals(NativeLanguage.CPP.toString()) ? NativeLanguage.CPP : NativeLanguage.C;
        projectData.basicProjectInfo.projectName = nameData.moduleName;
        projectData.basicProjectInfo.projectPath = String.valueOf(this.project.getLocation().toString()) + File.separator + "nacl_modules" + File.separator + nameData.moduleName;
        INaclPreferences preferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        projectData.basicProjectInfo.toolchain = preferences.getNaClToolchain(this.project);
        projectData.basicProjectInfo.hasToolchainPath = preferences.isCustomNaClToolchainSet(this.project);
        NaclSizeWizardPage.Data sizeData = this.sizePage.getData();
        projectData.configurationData.isPluginHidden = !sizeData.moduleVisible;
        projectData.configurationData.pluginHeight = sizeData.canvasSize.y;
        projectData.configurationData.pluginWidth = sizeData.canvasSize.x;
        projectData.configurationData.pluginPosition = sizeData.absolutePositionSet ? sizeData.absolutePosition : new Point(-1, -1);
        projectData.configurationData.screenResolutionIndex = 2;
        projectData.contentData.listTemplates = new LinkedList();
        for (String s : templateData.selectedInterfaces) {
            projectData.contentData.listTemplates.add(PluginConfig.ETemplateInterfaces.toEnumValue((String)s));
        }
        if (templateData.projectType.equals(ProjectData.ProjectType.Example.toString())) {
            projectData.contentData.projectSource = templateData.sampleName;
        } else {
            projectData.contentData.projectSource = "";
            projectData.contentData.headerFilePath = nameData.headerFilePath;
            projectData.contentData.sourceFilePath = nameData.sourceFilePath;
        }
        ProjectData.ProjectType[] projectTypeArray = ProjectData.ProjectType.values();
        int n = projectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectData.ProjectType projectType = projectTypeArray[n2];
            if (projectType.toString().equals(templateData.projectType)) {
                projectData.contentData.projectType = projectType;
            }
            ++n2;
        }
        projectData.contentData.requiredLibraries = PluginConfig.getInstance().getRequiredLibrariesForExample(projectData.contentData.projectSource);
        return this.backgroundFinish(projectData);
    }

    private boolean backgroundFinish(final ProjectData projectData) {
        this.errorMessage = null;
        final Display display = Display.getCurrent();
        Job job = new Job(Messages.NaClModuleWizard_CreatingProject){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NaClModuleWizard_CreatingProject, (int)100);
                    PNaClProjectProvider provider = PNaClProjectProvider.create((ProjectData.ProjectType)projectData.contentData.projectType, (IProgressMonitor)progress.newChild(50));
                    IProject naClProject = null;
                    naClProject = provider.createProject(projectData);
                    ProjectUtils.addReferencedProjects((IProject)NaClModuleWizard.this.project, (IProject[])new IProject[]{naClProject}, (IProgressMonitor)progress.newChild(20));
                    NaClModuleInserter.insertModule(naClProject, NaClModuleWizard.this.project);
                    NaClModuleWizard.this.project.refreshLocal(2, (IProgressMonitor)progress.newChild(10));
                    final IProject naclProjectToBuild = naClProject;
                    Job buildJob = new Job("Build project: " + naClProject.getName()){

                        protected IStatus run(IProgressMonitor buildMonitor) {
                            if (naclProjectToBuild != null) {
                                try {
                                    naclProjectToBuild.build(100, buildMonitor);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    buildJob.setPriority(40);
                    buildJob.schedule();
                    progress.worked(20);
                }
                catch (NullPointerException | CoreException e) {
                    e.printStackTrace();
                    NaClModuleWizard.this.errorMessage = "Adding NaCl module failed.";
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (NaClModuleWizard.this.errorMessage != null && !NaClModuleWizard.this.errorMessage.isEmpty()) {
                    display.asyncExec((Runnable)new ResultReporter(NaClModuleWizard.this.getShell(), NaClModuleWizard.this.errorMessage));
                }
            }
        });
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setPriority(10);
        job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        IProject selectedProject = ProjectUtils.getCurrentProject((ISelection)selection);
        try {
            if (selectedProject != null && ProjectUtils.isWebTvTizenProject((IProject)selectedProject) && selectedProject.hasNature("org.tizen.web.tv.sec.nacl.common.plugin.TizenProjectPNaClNature")) {
                this.project = selectedProject;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IWizardPage getStartingPage() {
        if (this.project == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NaClModuleWizard_NoParentProjectSelected, (String)Messages.NaClModuleWizard_SelectTizenProject);
            return null;
        }
        return super.getStartingPage();
    }

    public void createPageControls(Composite pageContainer) {
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener(this.listener);
        super.createPageControls(pageContainer);
    }
}

