/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.common.plugin;

import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.tizen.web.tv.sec.nacl.common.plugin.Messages;

public class UiUtils {
    private static void addReadmeSection(StyledText styledText, String title, String text) {
        StyleRange boldStyleRange = new StyleRange();
        boldStyleRange.fontStyle = 1;
        boldStyleRange.start = styledText.getText().length();
        boldStyleRange.length = title.length();
        styledText.append(String.valueOf(title) + System.lineSeparator());
        styledText.append(text);
        styledText.setStyleRange(boldStyleRange);
    }

    public static <T> void callOnUiThread(boolean shouldCallSynchronously, final Consumer<T> consumer, T param) {
        UiUtils.callOnUiThread(shouldCallSynchronously, new VarArgFunction<T, Object>(){

            @Override
            public Object function(T ... params) {
                if (params.length == 1) {
                    consumer.accept(params[0]);
                }
                return null;
            }
        }, param);
    }

    @SafeVarargs
    public static <T, R> R callOnUiThread(boolean shouldCallSynchronously, VarArgFunction<T, R> function, T ... params) {
        RunnableWithReturnValue<T, R> callee = new RunnableWithReturnValue<T, R>(function, params);
        if (shouldCallSynchronously) {
            Display.getDefault().syncExec(callee);
        } else {
            Display.getDefault().asyncExec(callee);
        }
        return callee.getReturnValue();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static boolean isPluginInstalled(String pluginName) {
        Bundle plugin = Platform.getBundle((String)pluginName);
        return plugin != null;
    }

    public static void setReadmeText(StyledText styledText, ExampleReadme readme) {
        boolean wasVisible = styledText.getVisible();
        if (wasVisible) {
            styledText.setVisible(false);
        }
        styledText.setStyleRanges(null, null);
        styledText.setText("");
        UiUtils.addReadmeSection(styledText, readme.name, "");
        styledText.append(System.lineSeparator());
        UiUtils.addReadmeSection(styledText, Messages.UiUtils_README_DESCRIPTION, readme.description);
        styledText.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        UiUtils.addReadmeSection(styledText, Messages.UiUtils_README_HOW_TO, readme.showsHowTo);
        styledText.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        UiUtils.addReadmeSection(styledText, Messages.UiUtils_README_NICE_TO_KNOW, readme.niceToAlreadyKnow);
        styledText.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        UiUtils.addReadmeSection(styledText, Messages.UiUtils_README_MORE_INFO, readme.moreInfo);
        if (wasVisible) {
            styledText.setVisible(true);
        }
    }

    public static class ExampleReadme {
        public String name = "";
        public String description = "";
        public String showsHowTo = "";
        public String niceToAlreadyKnow = "";
        public String requirements = "";
        public String moreInfo = "";
        public String filesDescription = "";
        public String cheatSheetId = "";
    }

    public static interface IErrorChecker {
        public boolean checkForError(String var1, boolean var2);
    }

    private static class RunnableWithReturnValue<T, R>
    implements Runnable {
        private final VarArgFunction<T, R> function;
        private final T[] params;
        private R retVal = null;

        public RunnableWithReturnValue(VarArgFunction<T, R> function, T ... params) {
            this.function = function;
            this.params = params;
        }

        public R getReturnValue() {
            return this.retVal;
        }

        @Override
        public void run() {
            this.retVal = this.function.function(this.params);
        }
    }

    public static interface VarArgFunction<T, R> {
        public R function(T ... var1);
    }
}

