/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.add_wasm_module.wizard;

import java.nio.file.Paths;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.Messages;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.NameAndLayoutPage;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.SampleSelectionPage;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferences;
import org.tizen.web.tv.sec.wasm.project.EmscriptenConfigData;
import org.tizen.web.tv.sec.wasm.project.IProjectData;
import org.tizen.web.tv.sec.wasm.project.ProjectData;
import org.tizen.web.tv.sec.wasm.project.ProjectFactory;
import org.tizen.web.tv.sec.wasm.project.WasmModuleLayout;
import org.tizen.web.tv.sec.wasm.project.WasmSample;
import org.tizen.web.tv.sec.wasm.project.merger.WasmModuleInserter;

public class AddWasmModule
extends Wizard
implements INewWizard {
    public static final String WASM_MODULES_DIR = "wasm_modules";
    public static final String SAMPLE_SELECTION_PAGE_NAME = "SamplePage";
    public static final String NAME_PAGE_NAME = "NamePage";
    public static final String LAYOUT_PAGE_NAME = "LayoutPage";
    private final SampleSelectionPage samplePage = new SampleSelectionPage("SamplePage");
    private final NameAndLayoutPage layoutPage = new NameAndLayoutPage("LayoutPage");
    private IProject tizenProject = null;

    public AddWasmModule() {
        this.setWindowTitle(Messages.AddWasmModule_AddWasmModule);
    }

    public void addPages() {
        if (this.tizenProject != null) {
            this.addPage((IWizardPage)this.samplePage);
            this.addPage((IWizardPage)this.layoutPage);
        }
    }

    private IProjectData collectProjectData() {
        String emCache;
        String emConfig;
        String modulePath;
        block13: {
            modulePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            emConfig = "";
            emCache = "";
            try {
                try {
                    if (this.tizenProject != null) {
                        modulePath = Paths.get(this.tizenProject.getLocation().toOSString(), WASM_MODULES_DIR).toString();
                        emConfig = WasmPreferences.getEmscriptenConfigPath((IProject)this.tizenProject);
                        emCache = WasmPreferences.getEmscriptenCachePath((IProject)this.tizenProject);
                    }
                }
                catch (WasmPreferences.PreferencesOperationException preferencesOperationException) {
                    System.err.println("No toolchain binary path stored for the project: " + this.tizenProject.getName());
                    if (emConfig.isEmpty()) {
                        emConfig = WasmPreferences.getEmscriptenConfigPath();
                    }
                    if (emCache.isEmpty()) {
                        emCache = WasmPreferences.getEmscriptenCachePath();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (emConfig.isEmpty()) {
                    emConfig = WasmPreferences.getEmscriptenConfigPath();
                }
                if (emCache.isEmpty()) {
                    emCache = WasmPreferences.getEmscriptenCachePath();
                }
                throw throwable;
            }
            if (emConfig.isEmpty()) {
                emConfig = WasmPreferences.getEmscriptenConfigPath();
            }
            if (emCache.isEmpty()) {
                emCache = WasmPreferences.getEmscriptenCachePath();
            }
        }
        WasmModuleLayout layout = this.layoutPage.getModuleLayout();
        WasmSample sample = this.samplePage.getSelectedSample();
        if (sample.getLayout() == null) {
            sample = new WasmSample(sample, layout);
        }
        return new ProjectData(this.layoutPage.getModuleName(), modulePath, new EmscriptenConfigData(emConfig, emCache), sample);
    }

    public boolean performFinish() {
        final IProjectData projectData = this.collectProjectData();
        Job createProject = new Job(Messages.AddWasmModule_AddingWasmModule){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AddWasmModule_CreatingWasmProject, (int)6);
                String packageId = ((Object)((Object)this)).getClass().getPackage().getName();
                try {
                    IProject wasmModule = ProjectFactory.createProject((IProjectData)projectData, (IProgressMonitor)progress.split(3));
                    if (AddWasmModule.this.tizenProject != null) {
                        ProjectUtils.addReferencedProjects((IProject)AddWasmModule.this.tizenProject, (IProject[])new IProject[]{wasmModule}, (IProgressMonitor)progress.split(1));
                        WasmModuleInserter.insertWasmModule((IProjectData)projectData, (IProject)AddWasmModule.this.tizenProject, (IProgressMonitor)progress.split(2));
                    }
                }
                catch (BuildException | CoreException e) {
                    return new Status(4, packageId, Messages.AddWasmModule_FailedToAddWasmModule, e);
                }
                return new Status(0, packageId, Messages.AddWasmModule_AddingModuleSucceeded);
            }
        };
        createProject.setUser(true);
        createProject.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject project = ProjectUtils.getCurrentProject((ISelection)selection);
        try {
            if (project != null && ProjectUtils.isWebTvTizenProject((IProject)project) && project.hasNature("org.tizen.web.tv.sec.wasm.common.plugin.TizenProjectWasmNature")) {
                this.tizenProject = project;
            }
        }
        catch (CoreException e) {
            System.err.println("No WASM-enabled Tizen project selected");
            e.printStackTrace();
        }
    }

    public IWizardPage getStartingPage() {
        if (this.tizenProject == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AddWasmModule_NoParentProjectSelected, (String)Messages.AddWasmModule_SelectTizenProject);
        }
        return super.getStartingPage();
    }

    public IProject getTizenProject() {
        return this.tizenProject;
    }
}

