/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.add_wasm_module.wizard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.Messages;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.WizardPageErrorChecker;
import org.tizen.web.tv.sec.wasm.project.WasmModuleLayout;

public class NameAndLayoutPage
extends WizardPage {
    private static final String SUGGESTED_MODULE_NAME = "wasm_module1";
    private static final int MODULE_NAME_MAX_LENGTH = 30;
    private static final String MODULE_NAME_REGEX = "[a-zA-Z0-9_]*";
    private static final String INCORRECT_MODULE_NAME = String.valueOf(Messages.NameAndLayoutPage_NameMustBe) + " " + 30 + " " + Messages.NameAndLayoutPage_CharactersLong;
    private final WizardPageErrorChecker<String, NameAndLayoutPage> errorChecker;
    private static final Pattern MODULE_NAME_WITH_NUMBER_REGEX = Pattern.compile("^(\\D*)(\\d+)$");
    private Spinner canvasWidthSpinner = null;
    private Spinner canvasHeightSpinner = null;
    private Spinner textAreaRowsSpinner = null;
    private Spinner textAreaColsSpinner = null;
    private WasmModuleLayout moduleLayout = null;
    private Button textAreaOnCheckbox = null;
    private Button canvasOnCheckbox = null;
    private final ModifyListener layoutModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NameAndLayoutPage.this.updateModuleLayout();
        }
    };
    private Composite container = null;
    private Group grpCanvas;
    private Group grpTextArea;
    private Text moduleNameText;
    private String name = null;

    public NameAndLayoutPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.NameAndLayoutPage_PageTitle);
        this.setDescription(Messages.NameAndLayoutPage_Desciption);
        this.errorChecker = new WizardPageErrorChecker(this);
    }

    private static String getNextFreeName(String origName) {
        String name;
        Matcher matcher = MODULE_NAME_WITH_NUMBER_REGEX.matcher(origName);
        if (!matcher.find()) {
            return origName;
        }
        String prefix = matcher.group(1);
        int number = Integer.parseInt(matcher.group(2));
        while (ProjectUtils.existsProject((String)(name = String.valueOf(prefix) + number))) {
            ++number;
        }
        return name;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group(this.container, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        group.setText(Messages.NameAndLayoutPage_ModuleName);
        group.setLayout((Layout)new GridLayout(1, false));
        this.moduleNameText = new Text((Composite)group, 2048);
        this.moduleNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moduleNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String moduleName = NameAndLayoutPage.this.moduleNameText.getText();
                NameAndLayoutPage.this.errorChecker.checkForError(Messages.NameAndLayoutPage_ProjectAlreadyExists, () -> ProjectUtils.existsProject((String)moduleName));
                NameAndLayoutPage.this.errorChecker.checkForError(INCORRECT_MODULE_NAME, () -> moduleName.isEmpty() || !moduleName.matches(NameAndLayoutPage.MODULE_NAME_REGEX) || moduleName.length() > 30);
                NameAndLayoutPage.this.storeDataFromControls();
            }
        });
        this.moduleNameText.setText(NameAndLayoutPage.getNextFreeName(SUGGESTED_MODULE_NAME));
        this.grpCanvas = new Group(this.container, 0);
        this.grpCanvas.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpCanvas.setText(Messages.NameAndLayoutPage_Canvas);
        this.grpCanvas.setLayout((Layout)new GridLayout(3, false));
        this.canvasOnCheckbox = new Button((Composite)this.grpCanvas, 32);
        this.canvasOnCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NameAndLayoutPage.this.canvasWidthSpinner != null) {
                    NameAndLayoutPage.this.canvasWidthSpinner.setEnabled(NameAndLayoutPage.this.canvasOnCheckbox.getSelection());
                }
                if (NameAndLayoutPage.this.canvasHeightSpinner != null) {
                    NameAndLayoutPage.this.canvasHeightSpinner.setEnabled(NameAndLayoutPage.this.canvasOnCheckbox.getSelection());
                }
                NameAndLayoutPage.this.updateModuleLayout();
            }
        });
        this.canvasOnCheckbox.setText(Messages.NameAndLayoutPage_On);
        new Label((Composite)this.grpCanvas, 0);
        new Label((Composite)this.grpCanvas, 0);
        Label widthLabel = new Label((Composite)this.grpCanvas, 0);
        widthLabel.setText(Messages.NameAndLayoutPage_Width);
        this.canvasWidthSpinner = new Spinner((Composite)this.grpCanvas, 2048);
        this.canvasWidthSpinner.setTextLimit(4);
        this.canvasWidthSpinner.addModifyListener(this.layoutModifyListener);
        this.canvasWidthSpinner.setEnabled(false);
        this.canvasWidthSpinner.setPageIncrement(100);
        this.canvasWidthSpinner.setMaximum(7680);
        this.canvasWidthSpinner.setSelection(100);
        Label lblNewLabel_4 = new Label((Composite)this.grpCanvas, 0);
        lblNewLabel_4.setText(Messages.NameAndLayoutPage_px);
        Label heightLabel = new Label((Composite)this.grpCanvas, 0);
        heightLabel.setText(Messages.NameAndLayoutPage_Height);
        this.canvasHeightSpinner = new Spinner((Composite)this.grpCanvas, 2048);
        this.canvasHeightSpinner.setTextLimit(4);
        this.canvasHeightSpinner.setEnabled(false);
        this.canvasHeightSpinner.setPageIncrement(100);
        this.canvasHeightSpinner.setMaximum(4320);
        this.canvasHeightSpinner.setSelection(100);
        this.canvasHeightSpinner.addModifyListener(this.layoutModifyListener);
        Label lblNewLabel_5 = new Label((Composite)this.grpCanvas, 0);
        lblNewLabel_5.setText(Messages.NameAndLayoutPage_px);
        this.grpTextArea = new Group(this.container, 0);
        this.grpTextArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpTextArea.setText(Messages.NameAndLayoutPage_TextArea);
        this.grpTextArea.setLayout((Layout)new GridLayout(2, false));
        this.textAreaOnCheckbox = new Button((Composite)this.grpTextArea, 32);
        this.textAreaOnCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NameAndLayoutPage.this.textAreaRowsSpinner != null) {
                    NameAndLayoutPage.this.textAreaRowsSpinner.setEnabled(NameAndLayoutPage.this.textAreaOnCheckbox.getSelection());
                }
                if (NameAndLayoutPage.this.textAreaColsSpinner != null) {
                    NameAndLayoutPage.this.textAreaColsSpinner.setEnabled(NameAndLayoutPage.this.textAreaOnCheckbox.getSelection());
                }
                NameAndLayoutPage.this.updateModuleLayout();
            }
        });
        this.textAreaOnCheckbox.setText(Messages.NameAndLayoutPage_On);
        new Label((Composite)this.grpTextArea, 0);
        Label columnsLabel = new Label((Composite)this.grpTextArea, 0);
        columnsLabel.setText(Messages.NameAndLayoutPage_Columns);
        this.textAreaColsSpinner = new Spinner((Composite)this.grpTextArea, 2048);
        this.textAreaColsSpinner.setTextLimit(4);
        this.textAreaColsSpinner.setEnabled(false);
        this.textAreaColsSpinner.setMaximum(1000);
        this.textAreaColsSpinner.setSelection(40);
        this.textAreaColsSpinner.addModifyListener(this.layoutModifyListener);
        Label rowsLabel = new Label((Composite)this.grpTextArea, 0);
        rowsLabel.setText(Messages.NameAndLayoutPage_Rows);
        this.textAreaRowsSpinner = new Spinner((Composite)this.grpTextArea, 2048);
        this.textAreaRowsSpinner.setTextLimit(4);
        this.textAreaRowsSpinner.setEnabled(false);
        this.textAreaRowsSpinner.setMaximum(1000);
        this.textAreaRowsSpinner.setSelection(25);
        this.textAreaRowsSpinner.addModifyListener(this.layoutModifyListener);
        this.updateModuleLayout();
    }

    private static int parseInt(String numberStr) {
        int ret = 0;
        if (numberStr == null) {
            return ret;
        }
        try {
            ret = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Failed to parse int from string: " + numberStr);
        }
        return ret;
    }

    private void updateModuleLayout() {
        if (this.textAreaOnCheckbox == null || this.textAreaColsSpinner == null || this.textAreaRowsSpinner == null || this.canvasOnCheckbox == null || this.canvasWidthSpinner == null || this.canvasHeightSpinner == null) {
            return;
        }
        WasmModuleLayout.Canvas canvas = null;
        WasmModuleLayout.TextArea textArea = null;
        if (this.canvasOnCheckbox.getSelection()) {
            canvas = new WasmModuleLayout.Canvas(NameAndLayoutPage.parseInt(this.canvasWidthSpinner.getText()), NameAndLayoutPage.parseInt(this.canvasHeightSpinner.getText()));
        }
        if (this.textAreaOnCheckbox.getSelection()) {
            textArea = new WasmModuleLayout.TextArea(NameAndLayoutPage.parseInt(this.textAreaColsSpinner.getText()), NameAndLayoutPage.parseInt(this.textAreaRowsSpinner.getText()));
        }
        this.moduleLayout = new WasmModuleLayout(canvas, textArea);
    }

    public String getModuleName() {
        return this.name;
    }

    public WasmModuleLayout getModuleLayout() {
        return this.moduleLayout;
    }

    public void enableLayoutControls(boolean enable) {
        if (this.grpCanvas == null || this.grpTextArea == null) {
            return;
        }
        this.grpCanvas.setVisible(enable);
        this.grpTextArea.setVisible(enable);
        if (enable) {
            this.setDescription(Messages.NameAndLayoutPage_Desciption);
        } else {
            this.setDescription(Messages.NameAndLayoutPage_NothingToSet);
        }
    }

    private void storeDataFromControls() {
        if (this.moduleNameText == null) {
            return;
        }
        if (this.isPageComplete()) {
            this.name = this.moduleNameText.getText();
        }
    }
}

