/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.common.JSONException;
import org.tizen.web.tv.sec.launch.step.SecTVDebugStep;
import org.tizen.web.tv.sec.launch.step.SecTVInstallStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.HTTPResponseCode;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.step.DebugInspectorOpenStep;
import org.tizen.web.zimlaunch.step.DebugPortSettingStep;
import org.tizen.web.zimlaunch.step.DebugURLSettingStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.step.RdsDeltaInputStep;

public class SecTVDebugURLSettingStep
extends DebugURLSettingStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVDebugURLSettingStep.class);
    private int errorCode = 0;
    private IOException IOerror = null;
    protected static final String LATEST_JSON_DATA_DEFAULT_PATH = "json";
    protected static final String TV_JSON_DATA_DEFAULT_PATH = "pagelist.json";
    protected static final String REMOTE_INSPECTOR_URL_KEY_FOR_TV = "inspectorUrl";
    protected static final String DEFAULT_INSPECTOR_PAGE_URL = "inspector.html?page=1";

    protected String getJsonPath(IDevice device, String profileName, String platformVersion) throws TimeoutException, SdbCommandRejectedException, IOException {
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
        if (version.isSameOrBiggerThanVersion3()) {
            return LATEST_JSON_DATA_DEFAULT_PATH;
        }
        return TV_JSON_DATA_DEFAULT_PATH;
    }

    protected String getInspectorPathKey(IDevice device, String profileName, String platformVersion) throws TimeoutException, SdbCommandRejectedException, IOException {
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
        if (version.isSameOrBiggerThanVersion3()) {
            return "devtoolsFrontendUrl";
        }
        return REMOTE_INSPECTOR_URL_KEY_FOR_TV;
    }

    public void executeStep(ILaunchContext ctx) throws CoreException {
        UserLogger.start((String)"web.launch", (String)".debug.url.setting");
        this.preExecuteStep(ctx);
        try {
            try {
                String debugUrl = null;
                int tryCnt = 0;
                while (tryCnt < 10) {
                    debugUrl = this.getDebugUrl("http://127.0.0.1:", this.lport);
                    if (debugUrl != null) break;
                    ++tryCnt;
                    Thread.sleep(1000L);
                }
                if (debugUrl == null) {
                    StringBuilder msgBuilder = new StringBuilder();
                    msgBuilder.append("Sorry, connection to the Web Inspector failed.\n\n").append("Please try one of the following three possible solutions : \n").append("1) Restart the web app in debug mode. \n\n").append("2) If some other app is already running in debug mode, first exit that app and then start debugging your current app \n ").append("3) Restart the target Emulator or TV");
                    this.openMessageBox(34, "Web Inspector connection result", msgBuilder.toString());
                } else {
                    ctx.setValue((Object)"url", debugUrl);
                }
                logger.debug("Debugging URL: " + debugUrl, (Object)this.getWorkCount(100));
            }
            catch (Exception e) {
                this.generalError(this.IOerror + "\n" + e.getLocalizedMessage() + "\n" + "Please try one of the following two possible solutions : " + "\n" + "1) If some other app is already running in debug mode, first exit that app and then start debugging your current app." + "\n" + "2) Restart the target Emulator or TV.", this.errorCode);
                UserLogger.end((String)"web.launch", (String)".debug.url.setting");
            }
        }
        finally {
            UserLogger.end((String)"web.launch", (String)".debug.url.setting");
        }
    }

    private int openMessageBox(final int style, final String title, final String msg) {
        final AtomicInteger retValue = new AtomicInteger();
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageBox dialog = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), style);
                dialog.setText(title);
                dialog.setMessage(msg);
                retValue.set(dialog.open());
            }
        });
        return retValue.get();
    }

    protected SecTVInstallStep newInstallStep() {
        return new SecTVInstallStep(new RdsDeltaInputStep());
    }

    protected IStep getCommonDebugSteps() {
        return new SecTVDebugStep(new DebugPortSettingStep(), new SecTVDebugURLSettingStep(), new DebugInspectorOpenStep());
    }

    protected String getDebugUrl(String baseUrl, int port) throws CoreException {
        TizenDeviceInfo deviceInfo = this.resource.getDeviceinfo();
        String inspectorPath = deviceInfo.getInspectorPath();
        String jsonPath = null;
        String inspectorUrlKey = null;
        String debugUrl = null;
        if (StringUtil.isEmpty((CharSequence)inspectorPath)) {
            block6: {
                IDevice device = deviceInfo.getDevice();
                PlatformInfo platformInfo = device.getPlatformInfo();
                String profileName = platformInfo.getProfileName();
                String platformVersion = platformInfo.getPlatformVersion();
                jsonPath = this.getJsonPath(device, profileName, platformVersion);
                logger.debug("jsonPath : " + jsonPath);
                inspectorUrlKey = this.getInspectorPathKey(device, profileName, platformVersion);
                if (port != 0) break block6;
                return null;
            }
            try {
                inspectorPath = this.getInspectorPath(baseUrl, port, jsonPath, inspectorUrlKey);
                if (!this.isSameOrBiggerThanVersionTizen30() && (inspectorPath == null || inspectorPath.equals(""))) {
                    inspectorPath = DEFAULT_INSPECTOR_PAGE_URL;
                }
                if (!inspectorPath.startsWith("/")) {
                    inspectorPath = "/" + inspectorPath;
                }
                debugUrl = String.valueOf(baseUrl) + port + inspectorPath;
                logger.debug("debugUrl : " + debugUrl);
            }
            catch (IOException e) {
                int code = TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_WEBKIT_RESPONSE.getCode();
                this.IOerror = e;
                this.errorCode = code;
            }
        }
        return debugUrl;
    }

    /*
     * Loose catch block
     */
    protected String getInspectorPath(String baseUrl, int port, String jsonPath, String inspectorUrlKey) throws IOException, CoreException {
        String inspectorPath;
        block11: {
            int code = 0;
            String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpResponse response = null;
            response = this.getHttpResponse(httpclient, String.valueOf(baseUrl) + port + "/" + jsonPath);
            logger.debug("http response : " + response);
            if (response == null || 200 != (code = response.getStatusLine().getStatusCode())) {
                errMsg = String.valueOf(StringUtil.trim((String)errMsg)) + "\n (Return Code:" + code + ")" + HTTPResponseCode.getDescriptionforCode((int)code);
                TizenWebIDEException.abort((String)(String.valueOf(Messages.getFailMessage((String)Messages.STEP_DEBUG_URL_SETTING)) + "\n" + TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_WEBKIT_RESPONSE), (Throwable)new TizenWebIDEException(errMsg), (TizenWebNotifier[])new TizenWebNotifier[0]);
            }
            HttpEntity entity = response.getEntity();
            inspectorPath = "";
            if (entity != null) {
                InputStream instream = null;
                try {
                    code = TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_READ_CONTENT.getCode();
                    instream = entity.getContent();
                    int contentLength = (int)entity.getContentLength();
                    logger.debug("content length : " + contentLength);
                    String content = StringUtil.asString((InputStream)instream);
                    logger.debug("content : " + content);
                    if (content.length() != contentLength) {
                        this.generalError(errMsg, code);
                    }
                    inspectorPath = this.getJsonValue(content, inspectorUrlKey);
                    logger.debug("inpectorPath : " + inspectorPath);
                }
                catch (IllegalStateException illegalStateException) {
                    this.generalError(errMsg, code);
                    IOUtil.tryClose((Object[])new Object[]{instream});
                    httpclient.getConnectionManager().shutdown();
                    break block11;
                }
                catch (JSONException jSONException) {
                    this.generalError(errMsg, code);
                    IOUtil.tryClose((Object[])new Object[]{instream});
                    httpclient.getConnectionManager().shutdown();
                    break block11;
                }
                catch (IOException iOException) {
                    block12: {
                        if (this.isSameOrBiggerThanVersionTizen30() || inspectorPath != null && !inspectorPath.equals("")) break block12;
                        inspectorPath = DEFAULT_INSPECTOR_PAGE_URL;
                        {
                            catch (Throwable throwable) {
                                IOUtil.tryClose((Object[])new Object[]{instream});
                                httpclient.getConnectionManager().shutdown();
                                throw throwable;
                            }
                        }
                    }
                    IOUtil.tryClose((Object[])new Object[]{instream});
                    httpclient.getConnectionManager().shutdown();
                    break block11;
                }
                IOUtil.tryClose((Object[])new Object[]{instream});
                httpclient.getConnectionManager().shutdown();
            }
        }
        return inspectorPath;
    }

    private boolean isSameOrBiggerThanVersionTizen30() throws IOException {
        TizenDeviceInfo deviceInfo = this.resource.getDeviceinfo();
        IDevice device = deviceInfo.getDevice();
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
        return version.isSameOrBiggerThanVersion3();
    }
}

