/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.ParsingUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.PsInfo;
import org.tizen.sdblib.receiver.PsReceiver;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.web.config.schema.model.Service;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.tv.sec.launch.Activator;
import org.tizen.web.tv.sec.launch.command.SdbCmdSelector;
import org.tizen.web.tv.sec.launch.step.SecTVKillStep;
import org.tizen.web.tv.sec.launch.util.SecTVCommandLauncher;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogConsoleFactory;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogReceiver;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public abstract class SecTVLaunchStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVLaunchStep.class);
    protected SecTVCommandLauncher secTVlauncher;
    public static final String name = Messages.RUN_PACKAGE;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected IDevice device;
    protected boolean isInstalled;
    protected int percent;

    public SecTVLaunchStep(IStep ... steps) {
        super(steps);
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".run");
        this.preExecuteStep(ctx);
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        String cmd = this.getLaunchCommand();
        int code = 0;
        if (!this.isInstalled) {
            code = TizenWebIDEExceptionCode.WEB_IDE_WIDGET_NOT_INSTALLED.getCode();
            TizenWebIDEException.abort((String)Messages.getFailMessage((String)Messages.RUN_PACKAGE), (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
            return;
        }
        this.closeJsLogConsole(this.device);
        Calendar calendar = this.getCurrentDeviceCalendar(this.device);
        String clockTime = this.getCurrentDeviceClockTime(this.device);
        logger.debug("Command for running: " + cmd);
        this.launcher.runCommand(cmd, false);
        this.postRun();
        boolean isLaunched = this.launcher.isLaunched();
        if (!isLaunched) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPRUN_FAIL.getCode();
            TizenWebIDEException.abort((String)Messages.getFailMessage((String)Messages.RUN_PACKAGE), (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.openJsLogConsole(calendar, clockTime);
        try {
            try {
                super.executeStep(ctx);
            }
            catch (Exception e) {
                this.handleExecuteException(e, ctx);
                UserLogger.end((String)"web.launch", (String)".run");
            }
        }
        finally {
            UserLogger.end((String)"web.launch", (String)".run");
        }
    }

    protected void handleExecuteException(Exception e, ILaunchContext ctx) throws Exception {
        if (e != null) {
            new SecTVKillStep().executeStep(ctx);
            throw e;
        }
    }

    protected Calendar getCurrentDeviceCalendar(IDevice device) throws Exception {
        Date date;
        if (device == null) {
            return null;
        }
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = secTVWRTCommandUtil.getCommand("GET_DATE_COMMAND", null, this.resource);
        SimpleDateFormat ft = new SimpleDateFormat("y-MM-dd hh:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            this.launcher.runCommand(cmd, false);
            String result = this.launcher.getResultString();
            date = ft.parse(result);
        }
        catch (Exception exception) {
            date = calendar.getTime();
            String result = ft.format(date);
            date = ft.parse(result);
        }
        calendar.setTime(date);
        return calendar;
    }

    protected String getCurrentDeviceClockTime(IDevice device) throws Exception {
        String clockTime = "0";
        if (device == null) {
            return null;
        }
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = secTVWRTCommandUtil.getCommand("CLOCK_GETTIME_COMMAND", null, this.resource);
        try {
            this.launcher.runCommand(cmd, false);
            clockTime = this.launcher.getResultString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clockTime;
    }

    private void closeJsLogConsole(IDevice device) {
        if (device == null) {
            return;
        }
        SecTVJsLogConsoleFactory.closeJsLogConsole(device);
    }

    protected void openJsLogConsole(Calendar calendar, String clockTime) throws IOException {
        PsReceiver psReceiver = new PsReceiver();
        try {
            SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(ConnectionPlugin.getDefault().getCurrentDevice());
            String pscmd = sdbCmdSelector.getCmd("PS_INFO_COMMAND", null);
            this.device.executeShellCommand(pscmd, (IShellOutputReceiver)psReceiver);
            PsInfo[] appInfos = psReceiver.getPsInfos();
            Activator.PID_MODE = appInfos.length == 0 ? false : this.getPidOfWebProcess(this.resource.getAppinfo().getAppPackageID()) != 0;
        }
        catch (Exception exception) {
            Activator.PID_MODE = false;
        }
        TizenWebAppInfo appInfo = this.resource.getAppinfo();
        IProject project = appInfo.getProject();
        String packageID = appInfo.getAppPackageID();
        String serviceID = null;
        String appID = appInfo.getAppID();
        try {
            ITizenConfigurator config = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
            Service service = ((IMobileConfigurator)config).getService();
            if (service != null) {
                serviceID = service.getId();
            }
        }
        catch (ConfigurationException configurationException) {}
        SecTVJsLogReceiver receiver = null;
        if (Activator.PID_MODE) {
            receiver = new SecTVJsLogReceiver(Activator.PID_MODE);
        } else {
            receiver = new SecTVJsLogReceiver();
            receiver.setCalendar(calendar);
            receiver.setDeviceBootTime(clockTime);
        }
        if (Activator.PID_MODE) {
            try {
                SecTVJsLogConsoleFactory.openJsLogConsolebyPID(project, this.device, this.getPidOfWebProcess(this.resource.getAppinfo().getAppPackageID()), receiver);
            }
            catch (NoConnectedDeviceException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SecTVJsLogConsoleFactory.openJsLogConsole(project, this.device, packageID, serviceID, appID, receiver);
        }
    }

    protected void postRun() {
        String[] resultLineStrings = this.launcher.getResultLineStrings();
        if (resultLineStrings != null) {
            String[] stringArray = resultLineStrings;
            int n = resultLineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                logger.debug("  " + result);
                ++n2;
            }
        }
    }

    protected String getLaunchCommand() throws Exception {
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = null;
        try {
            if (Activator.getWebAppLaunchCommand().equals("app_launcher")) {
                cmd = secTVWRTCommandUtil.getCommand("RUN_LAUNCH_COMMAND", null, this.resource);
            } else if (Activator.getWebAppLaunchCommand().equals("wascmd")) {
                cmd = secTVWRTCommandUtil.getCommand("VD_RUN_LAUNCH_COMMAND", null, this.resource);
            }
        }
        catch (Exception exception) {
            cmd = secTVWRTCommandUtil.getCommand("VD_RUN_LAUNCH_COMMAND", null, this.resource);
        }
        return cmd;
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        String failMessage = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort((String)eMsg, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        String msg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        this.secTVlauncher = (SecTVCommandLauncher)((Object)ctx.getValue((Object)"command launcher"));
        if (this.secTVlauncher == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER));
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.device = this.resource.getDeviceinfo().getDevice();
        SecTVJsLogConsoleFactory.clear(this.device);
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort((String)eMsg, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.secTVlauncher.isInstalled(this.resource);
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : this.notifier.getRemainWork() - 1;
    }

    public String getStepName() {
        return name;
    }

    protected int getPidOfWebProcess(String appPKGName) throws Exception, IOException, NoConnectedDeviceException {
        PsReceiver psReceiver = null;
        try {
            PsInfo[] appInfos;
            psReceiver = new PsReceiver();
            SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(ConnectionPlugin.getDefault().getCurrentDevice());
            String pscmd = sdbCmdSelector.getCmd("PS_INFO_COMMAND", null);
            this.device.executeShellCommand(pscmd, (IShellOutputReceiver)psReceiver);
            int appPid = 0;
            PsInfo[] psInfoArray = appInfos = psReceiver.getPsInfos();
            int n = appInfos.length;
            int n2 = 0;
            while (n2 < n) {
                String pidStr;
                String cmd;
                PsInfo psInfo = psInfoArray[n2];
                if ("app".equals(psInfo.get("UID")) && !StringUtil.isEmpty((CharSequence)(cmd = psInfo.get("CMD"))) && cmd.contains(appPKGName) && !StringUtil.isEmpty((CharSequence)(pidStr = psInfo.get("PID"))) && (appPid = ParsingUtil.parseInt((String)pidStr, (int)appPid)) != 0) break;
                ++n2;
            }
            logger.trace("{}'s PID : {}", (Object)appPKGName, (Object)appPid);
            int n3 = appPid;
            return n3;
        }
        finally {
            IOUtil.tryClose((Closeable)psReceiver);
        }
    }
}

