/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.console.IConsoleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.web.tv.sec.launch.Activator;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogConsoleManager;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogReceiver;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class SecTVJsLogConsoleFactory
implements IConsoleFactory {
    public static final Logger logger = LoggerFactory.getLogger(SecTVJsLogConsoleFactory.class);
    private static HashMap<String, SecTVJsLogConsoleManager> consoleMap = new HashMap();
    private static boolean isListen = false;
    protected static FactoryWithArgument<SecTVJsLogConsoleManager, String> consoleManagerFactory = new FactoryWithArgument<SecTVJsLogConsoleManager, String>(){

        public SecTVJsLogConsoleManager create(String name) {
            return new SecTVJsLogConsoleManager(name, false);
        }
    };
    private static SecTVJsLogConsoleManager consoleManager;
    private IDevice device = null;

    public SecTVJsLogConsoleFactory(IDevice device) {
        this.device = device;
    }

    public void openConsole() {
        if (Activator.PID_MODE) {
            SecTVJsLogConsoleFactory.openJsLogConsolebyPID(null, this.device, 0, new SecTVJsLogReceiver(Activator.PID_MODE));
        } else {
            SecTVJsLogConsoleFactory.openJsLogConsole(null, this.device, "", "", "", new SecTVJsLogReceiver("", null));
        }
    }

    public static SecTVJsLogConsoleManager createJsLogConsole(String name) {
        return (SecTVJsLogConsoleManager)((Object)consoleManagerFactory.create((Object)name));
    }

    public static void setConsoleManagerFactory(FactoryWithArgument<SecTVJsLogConsoleManager, String> factory) {
        consoleManagerFactory = factory;
    }

    public static void setConsoleMap(HashMap<String, SecTVJsLogConsoleManager> consoleMap) {
        SecTVJsLogConsoleFactory.consoleMap = consoleMap;
    }

    private static void addListener() {
        if (!isListen) {
            SecTVJsLogConsoleDeviceListener listner = new SecTVJsLogConsoleDeviceListener();
            SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)listner);
            isListen = true;
        }
    }

    public static void openJsLogConsolebyPID(IProject project, IDevice device, int pid, SecTVJsLogReceiver receiver) {
        String name = JsLogConsoleUtil.getConsoleName((IDevice)device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            SecTVJsLogConsoleFactory.genConsoleManager(name);
        }
        try {
            consoleManager.openConsole(project, device, pid, receiver);
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void openJsLogConsole(IProject project, IDevice device, String packageID, String serviceID, String appID, SecTVJsLogReceiver receiver) {
        String name = JsLogConsoleUtil.getConsoleName((IDevice)device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            SecTVJsLogConsoleFactory.genConsoleManager(name);
        }
        try {
            consoleManager.openConsole(project, device, packageID, serviceID, appID, receiver);
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void openJsLogConsole(IProject project, IDevice device, String packageID, JsLogReceiver receiver) {
        String name = JsLogConsoleUtil.getConsoleName((IDevice)device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            SecTVJsLogConsoleFactory.genConsoleManager(name);
        }
        try {
            consoleManager.openConsole(project, device, packageID, receiver);
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void clear(IDevice device) {
        SecTVJsLogConsoleManager consoleManager = SecTVJsLogConsoleFactory.getConsoleManager(device);
        if (consoleManager != null) {
            consoleManager.clear();
        }
    }

    public static SecTVJsLogConsoleManager getConsoleManager(IDevice device) {
        if (device == null) {
            return null;
        }
        String name = JsLogConsoleUtil.getConsoleName((IDevice)device);
        consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            SecTVJsLogConsoleFactory.genConsoleManager(name);
        }
        return consoleManager;
    }

    private static void genConsoleManager(String name) {
        SecTVJsLogConsoleFactory.addListener();
        consoleManager = SecTVJsLogConsoleFactory.createJsLogConsole(name);
        consoleMap.put(name, consoleManager);
    }

    public static void closeJsLogConsole(IDevice device) {
        String name = JsLogConsoleUtil.getConsoleName((IDevice)device);
        SecTVJsLogConsoleManager consoleManager = consoleMap.get(name);
        if (consoleManager == null) {
            return;
        }
        try {
            consoleManager.closeConsole();
        }
        catch (IOException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static class SecTVJsLogConsoleDeviceListener
    implements IDeviceChangeListener {
        private SecTVJsLogConsoleDeviceListener() {
        }

        public void onConnected(IDevice device) {
        }

        public void onChanged(IDevice device, int changeMask) {
        }

        public void onDisconnected(IDevice device) {
            if (device != null) {
                consoleMap.remove(JsLogConsoleUtil.getConsoleName((IDevice)device));
                JsLogConsoleUtil.getConsoleManager().removeConsoles(JsLogConsoleUtil.getConsoles((IDevice)device));
            }
        }
    }
}

