/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.supportenabler;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.IToolchainContent;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferenceActivator;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferences;
import org.tizen.web.tv.sec.wasm.supportenabler.Messages;

public class WasmToolchainContent
implements IToolchainContent {
    private boolean emConfigValid = false;
    private boolean emCacheValid = false;
    private String emConfigPath = WasmPreferences.EM_CONFIG_DEFAULT_PATH;
    private String emCachePath = WasmPreferences.EM_CACHE_DEFAULT_PATH;
    private Composite wasmToolchainContainer = null;
    private Consumer<Boolean> enableToolchainConfirmation = null;
    private FileFieldEditor emscriptenConfigFile;
    private DirectoryFieldEditor emscriptenCacheDir;

    public void implementContent(Composite container, IProject tizenProject) {
        if (this.wasmToolchainContainer != null) {
            return;
        }
        this.wasmToolchainContainer = container;
        this.createContents(this.wasmToolchainContainer, tizenProject);
    }

    public void performFinish(IProject project, boolean toggleWasmNature) {
        try {
            WasmPreferences.storeEmscriptenConfigPath((String)this.getEmConfigPath());
            WasmPreferences.storeEmscriptenCachePath((String)this.getEmCachePath());
            WasmPreferences.storeEmscriptenConfigPath((IProject)project, (String)this.getEmConfigPath(), (IProgressMonitor)new NullProgressMonitor());
            WasmPreferences.storeEmscriptenCachePath((IProject)project, (String)this.getEmCachePath(), (IProgressMonitor)new NullProgressMonitor());
            if (toggleWasmNature) {
                ProjectUtils.toggleTizenProjectWasmNature((IProject)project, null);
            }
        }
        catch (WasmPreferences.PreferencesOperationException preferencesOperationException) {
            Logger.getGlobal().severe("Failed setting WASM toolchain path");
        }
        catch (CoreException e) {
            Logger.getGlobal().severe("Failed toggling WASM nature");
            e.printStackTrace();
        }
    }

    public void setEnableToolchainConfirmation(Consumer<Boolean> consumer) {
        this.enableToolchainConfirmation = consumer;
    }

    public String getEmConfigPath() {
        return this.emConfigPath;
    }

    public String getEmCachePath() {
        return this.emCachePath;
    }

    private void updateEnableState() {
        if (this.enableToolchainConfirmation == null) {
            return;
        }
        this.enableToolchainConfirmation.accept(this.emConfigValid && this.emCacheValid);
    }

    private void checkEmConfig(StringFieldEditor owner) {
        String filePathStr;
        this.emConfigPath = filePathStr = owner.getStringValue();
        File filePath = new File(filePathStr);
        this.emConfigValid = filePath.isFile() && filePath.canRead();
        this.updateEnableState();
    }

    private void checkEmCache(StringFieldEditor owner) {
        String dirStr;
        this.emCachePath = dirStr = owner.getStringValue();
        File dir = new File(dirStr);
        try {
            boolean bl = this.emCacheValid = dir.isDirectory() && dir.canWrite() || dir.createNewFile() && dir.delete();
            if (!this.emCacheValid) {
                System.err.println("Directory: " + dir.getAbsolutePath() + " cannot be used for cache");
            }
        }
        catch (IOException e) {
            System.err.println("I/O error while checking directory: \"" + dir.getAbsolutePath() + "\": " + e.getMessage());
            this.emCacheValid = false;
        }
        this.updateEnableState();
    }

    private void loadPaths(IProject tizenProject) {
        this.emscriptenConfigFile.setPreferenceStore(WasmPreferenceActivator.getDefault().getPreferenceStore());
        this.emscriptenCacheDir.setPreferenceStore(WasmPreferenceActivator.getDefault().getPreferenceStore());
        this.emscriptenConfigFile.setStringValue(WasmPreferences.EM_CONFIG_DEFAULT_PATH);
        this.emscriptenCacheDir.setStringValue(WasmPreferences.EM_CACHE_DEFAULT_PATH);
        if (tizenProject != null) {
            try {
                this.emscriptenConfigFile.setStringValue(WasmPreferences.getEmscriptenConfigPath((IProject)tizenProject));
                this.emscriptenCacheDir.setStringValue(WasmPreferences.getEmscriptenCachePath((IProject)tizenProject));
                if (this.emscriptenConfigFile.getStringValue().isEmpty()) {
                    this.emscriptenConfigFile.load();
                }
                if (this.emscriptenCacheDir.getStringValue().isEmpty()) {
                    this.emscriptenCacheDir.load();
                }
            }
            catch (WasmPreferences.PreferencesOperationException preferencesOperationException) {
                System.err.println("Failed to read the Emscripten config from the project preferences.");
            }
        } else {
            this.emscriptenConfigFile.load();
            if (this.emscriptenConfigFile.getStringValue().isEmpty()) {
                this.emscriptenConfigFile.setStringValue(WasmPreferences.EM_CONFIG_DEFAULT_PATH);
            }
            this.emscriptenCacheDir.load();
            if (this.emscriptenCacheDir.getStringValue().isEmpty()) {
                this.emscriptenCacheDir.setStringValue(WasmPreferences.EM_CACHE_DEFAULT_PATH);
            }
        }
    }

    private void createContents(Composite parent, IProject tizenProject) {
        Composite wasmGroup = new Composite(parent, 0);
        wasmGroup.setBounds(parent.getBounds());
        wasmGroup.setLayout((Layout)new GridLayout(1, false));
        wasmGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final Group group = new Group(wasmGroup, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group.setText(Messages.WasmToolchainContent_EmscriptenSdkConfig);
        group.setLayout((Layout)new GridLayout(1, false));
        this.emscriptenConfigFile = new FileFieldEditor("emscripten.config", Messages.WasmToolchainContent_ConfigFile, true, 0, (Composite)group){

            protected void valueChanged() {
                WasmToolchainContent.this.checkEmConfig((StringFieldEditor)this);
            }
        };
        this.emscriptenConfigFile.setFilterPath(new File(WasmPreferences.HOME_DIR));
        this.emscriptenConfigFile.setEmptyStringAllowed(false);
        this.emscriptenCacheDir = new DirectoryFieldEditor("emscripten.cache", Messages.WasmToolchainContent_CacheDir, (Composite)group){

            protected void valueChanged() {
                WasmToolchainContent.this.checkEmCache((StringFieldEditor)this);
            }

            protected void createControl(Composite parent) {
                this.setValidateStrategy(0);
                super.createControl(parent);
            }
        };
        this.emscriptenCacheDir.setFilterPath(new File(WasmPreferences.HOME_DIR));
        this.emscriptenCacheDir.setEmptyStringAllowed(false);
        group.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                group.removePaintListener((PaintListener)this);
                UIJob uiJob = new UIJob(Messages.WasmToolchainPage_JOB_DESCRIPTION){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        WasmToolchainContent.this.checkEmConfig((StringFieldEditor)WasmToolchainContent.this.emscriptenConfigFile);
                        WasmToolchainContent.this.checkEmCache((StringFieldEditor)WasmToolchainContent.this.emscriptenCacheDir);
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
            }
        });
        this.loadPaths(tizenProject);
    }
}

