/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.tizen.web.tv.sec.util.IOUtil;

public class FileOperator {
    public static String convertInputStreamToString(InputStream is) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (is == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            is.close();
            reader.close();
            br.close();
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public static String inputStreamToString(InputStream is) {
        if (is == null) {
            return "";
        }
        InputStreamReader reader = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            br = new BufferedReader(reader);
            sb = new StringBuilder();
            reader = new InputStreamReader(is, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            is.close();
            reader.close();
            br.close();
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public static InputStream stringToInputStream(String str) {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
        return stream;
    }

    public static File getPluginResource(Plugin plugin, String path) {
        try {
            URL url = plugin.getBundle().getEntry(path);
            if (url != null) {
                return new File(FileLocator.toFileURL((URL)url).getFile());
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static File getPluginResource(Bundle bundle, String path) {
        try {
            URL url = bundle.getEntry(path);
            if (url != null) {
                return new File(FileLocator.toFileURL((URL)url).getFile());
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static boolean writeFile2Project(IProject project, String path, String contents, IProgressMonitor monitor) {
        IFile file = project.getFile(path);
        ByteArrayInputStream bais = new ByteArrayInputStream(contents.getBytes(Charset.forName("UTF-8")));
        try {
            if (file != null) {
                if (file.exists()) {
                    file.setContents((InputStream)bais, true, true, monitor);
                } else {
                    file.create((InputStream)bais, true, monitor);
                }
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static boolean deleteFile(File file) {
        File[] childen;
        boolean result = true;
        if (file == null || !file.exists()) {
            return result;
        }
        if (file.isDirectory() && (childen = file.listFiles()) != null) {
            File[] fileArray = childen;
            int n = childen.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result &= FileOperator.deleteFile(child);
                ++n2;
            }
        }
        return result &= file.delete();
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("Can not find source: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Cannot read: " + src.getAbsolutePath() + ". Check file permissions.");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Could not create direcotry: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                FileOperator.copyFiles(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException("Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath());
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(fin, fout);
                throw throwable;
            }
            IOUtil.tryClose(fin, fout);
        }
    }

    public static IProject getProjectExplorerSelection() {
        Object obj;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewPart part = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (part == null) {
            return null;
        }
        IViewSite site = part.getViewSite();
        if (site == null) {
            return null;
        }
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return ((IResource)obj).getProject();
        }
        return null;
    }

    public static boolean isFileInWorkspaceRoot(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String temp = String.valueOf(root.getLocation().toOSString()) + File.separator + fileName;
        return new File(temp).exists();
    }

    public static boolean isProjectExists(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project != null && project.exists();
    }

    public static IPath getProjectLocationInWorkspace(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getLocation().append(projectName);
    }

    public static URI getProjectLocationURIInWorkspace(String projectName) {
        return URIUtil.toURI((IPath)FileOperator.getProjectLocationInWorkspace(projectName));
    }

    public static void addProjectToWorkingSets(IProject project, IWorkingSet ... workingSet) {
        if (project == null || workingSet == null || workingSet.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.addToWorkingSets((IAdaptable)project, workingSet);
    }

    public static IProject copyProject(IProject project, String newProjectName, URI locationURI, IProgressMonitor monitor) throws CoreException {
        boolean open = project.isOpen();
        if (!open) {
            project.open(null);
        }
        IProjectDescription description = project.getDescription();
        description.setName(newProjectName);
        description.setLocationURI(locationURI);
        project.copy(description, 33, monitor);
        if (!open) {
            project.close(null);
        }
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        IProject newPrj = root.getProject(newProjectName);
        return newPrj;
    }

    public static void addNatures2Project(IProjectDescription description, String ... natures) {
        if (description == null || natures == null || natures.length == 0) {
            return;
        }
        String[] alreadys = description.getNatureIds();
        String[] newNatures = new String[alreadys.length + natures.length];
        System.arraycopy(alreadys, 0, newNatures, 0, alreadys.length);
        System.arraycopy(natures, 0, newNatures, natures.length, natures.length);
        description.setNatureIds(newNatures);
    }

    public static String URLtoString(URL url) {
        if (url == null) {
            return null;
        }
        String s = url.toExternalForm();
        if (s.startsWith("file:/") && !s.startsWith("file://")) {
            s = s.replaceFirst("file:/", "file:///");
        }
        return s;
    }

    public static String URLtoFile(URL url) throws UnsupportedEncodingException {
        String path = URLDecoder.decode(url.getPath(), "UTF-8");
        return new File(path).getAbsolutePath();
    }

    public static enum ORDERACTION {
        BRINGTOP,
        BRINGBOTTON,
        MOVEUP,
        MOVEDOWN;

    }
}

