/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.project;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.tizen.web.tv.sec.nacl.common.DeepCloneable;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.wasm.project.Activator;
import org.tizen.web.tv.sec.wasm.project.WasmModuleLayout;
import org.tizen.web.tv.sec.wasm.project.WasmSample;

public class WasmSamples {
    public static final String EMPTY_SAMPLE_NAME = "Empty";
    public static final String SETTINGS_FILE_NAME = "settings.json";
    private static final String BUNDLE_SAMPLES_PATH = "/resources/templates";
    private static final String TEMPLATE_NODE_NAME = "template";
    private static final String BUILDER_NODE_NAME = "builder";
    private static final String CONFIGURATIONS_NODE_NAME = "configurations";
    private static final String NAME_NODE_NAME = "name";
    private static final String DESCRIPTION_NODE_NAME = "description";
    private static final String LAYOUT_NODE_NAME = "layout";
    private static final String CANVAS_NODE_NAME = "canvas";
    private static final String OUTPUT_NODE_NAME = "output";
    private static final String WIDTH_NODE_NAME = "width";
    private static final String HEIGHT_NODE_NAME = "height";
    private static final String COLUMNS_NODE_NAME = "columns";
    private static final String ROWS_NODE_NAME = "rows";
    private static final String C_FLAGS_NODE_NAME = "c_compiler_flags";
    private static final String CPP_FLAGS_NODE_NAME = "cpp_compiler_flags";
    private static final String LINKER_FLAGS_NODE_NAME = "linker_flags";
    private static final String LANGUAGE_NODE_NAME = "language";
    private final Map<String, WasmSample> samples = WasmSamples.loadSamples("/resources/templates");

    private static JsonNode getChildNode(JsonNode parent, String childNodeName) throws JsonNodeNotFoundException {
        JsonNode child = parent.get(childNodeName);
        if (child == null) {
            throw new JsonNodeNotFoundException(childNodeName);
        }
        return child;
    }

    private static WasmModuleLayout loadLayout(JsonNode templateNode) {
        WasmModuleLayout.Canvas canvas = null;
        WasmModuleLayout.TextArea output = null;
        JsonNode layoutNode = null;
        try {
            layoutNode = WasmSamples.getChildNode(templateNode, LAYOUT_NODE_NAME);
        }
        catch (JsonNodeNotFoundException jsonNodeNotFoundException) {
            System.out.println("No layout node found.");
            return null;
        }
        try {
            JsonNode canvasNode = WasmSamples.getChildNode(layoutNode, CANVAS_NODE_NAME);
            int width = WasmSamples.getChildNode(canvasNode, WIDTH_NODE_NAME).asInt();
            int height = WasmSamples.getChildNode(canvasNode, HEIGHT_NODE_NAME).asInt();
            canvas = new WasmModuleLayout.Canvas(width, height);
        }
        catch (JsonNodeNotFoundException jsonNodeNotFoundException) {
            System.out.println("No canvas node found.");
        }
        try {
            JsonNode outputNode = WasmSamples.getChildNode(layoutNode, OUTPUT_NODE_NAME);
            int columns = WasmSamples.getChildNode(outputNode, COLUMNS_NODE_NAME).asInt();
            int rows = WasmSamples.getChildNode(outputNode, ROWS_NODE_NAME).asInt();
            output = new WasmModuleLayout.TextArea(columns, rows);
        }
        catch (JsonNodeNotFoundException jsonNodeNotFoundException) {
            System.out.println("No output node found.");
        }
        return new WasmModuleLayout(canvas, output);
    }

    private static WasmSample loadSample(FilePaths[] sampleFilesPaths) throws JsonProcessingException, IOException, JsonNodeNotFoundException {
        HashSet<WasmSample.BuildConfiguration> buildConfigurations;
        WasmModuleLayout layout;
        String sampleLanguage;
        String sampleDescription;
        String sampleName;
        block23: {
            URL sampleSettingsUrl = null;
            FilePaths[] filePathsArray = sampleFilesPaths;
            int n = sampleFilesPaths.length;
            int n2 = 0;
            while (n2 < n) {
                FilePaths filePaths = filePathsArray[n2];
                if (filePaths.getUrl().getFile().endsWith(SETTINGS_FILE_NAME)) {
                    sampleSettingsUrl = filePaths.getUrl();
                    break;
                }
                ++n2;
            }
            if (sampleSettingsUrl == null) {
                System.err.println("settings.json not found in the sample's files.");
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(sampleSettingsUrl.openStream());
            if (root == null) {
                System.err.println("Could not parse the " + sampleSettingsUrl.toString() + " file.");
                return null;
            }
            JsonNode templateNode = WasmSamples.getChildNode(root, TEMPLATE_NODE_NAME);
            sampleName = WasmSamples.getChildNode(templateNode, NAME_NODE_NAME).textValue();
            sampleDescription = WasmSamples.getChildNode(templateNode, DESCRIPTION_NODE_NAME).textValue();
            sampleLanguage = WasmSamples.getChildNode(templateNode, LANGUAGE_NODE_NAME).textValue();
            layout = WasmSamples.loadLayout(templateNode);
            buildConfigurations = new HashSet<WasmSample.BuildConfiguration>();
            JsonNode builderNode = WasmSamples.getChildNode(root, BUILDER_NODE_NAME);
            JsonNode buildConfigs = WasmSamples.getChildNode(builderNode, CONFIGURATIONS_NODE_NAME);
            if (!buildConfigs.isArray()) break block23;
            Iterator buildConfig = ((ArrayNode)buildConfigs).elements();
            while (buildConfig.hasNext()) {
                String[] cCompilerFlags = new String[]{};
                String[] cppCompilerFlags = new String[]{};
                String[] linkerFlags = new String[]{};
                JsonNode buildConfigNode = (JsonNode)buildConfig.next();
                String name = WasmSamples.getChildNode(buildConfigNode, NAME_NODE_NAME).textValue();
                String[] stringArray = new String[]{C_FLAGS_NODE_NAME, CPP_FLAGS_NODE_NAME, LINKER_FLAGS_NODE_NAME};
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block22: {
                        String flagsNodeName = stringArray[n4];
                        try {
                            JsonNode flagsNode = WasmSamples.getChildNode(buildConfigNode, flagsNodeName);
                            if (!flagsNode.isArray()) break block22;
                            Iterator flagsIterator = ((ArrayNode)flagsNode).elements();
                            HashSet<String> flags = new HashSet<String>();
                            while (flagsIterator.hasNext()) {
                                String flag = ((JsonNode)flagsIterator.next()).textValue();
                                flags.add(flag);
                            }
                            String[] flagsArray = flags.toArray(new String[0]);
                            switch (flagsNodeName) {
                                case "c_compiler_flags": {
                                    cCompilerFlags = flagsArray;
                                    break;
                                }
                                case "cpp_compiler_flags": {
                                    cppCompilerFlags = flagsArray;
                                    break;
                                }
                                case "linker_flags": {
                                    linkerFlags = flagsArray;
                                }
                            }
                        }
                        catch (JsonNodeNotFoundException jsonNodeNotFoundException) {}
                    }
                    ++n4;
                }
                buildConfigurations.add(new WasmSample.BuildConfiguration(name, cCompilerFlags, cppCompilerFlags, linkerFlags));
            }
        }
        return new WasmSample(sampleName, sampleDescription, NativeLanguage.toEnumValue((String)sampleLanguage), layout, sampleFilesPaths, buildConfigurations.toArray(new WasmSample.BuildConfiguration[0]));
    }

    private static FilePaths[] getSampleFilesPaths(URL sampleUrl) {
        String sampleDirPath = sampleUrl.getFile();
        String sampleDirName = new Path(sampleDirPath).lastSegment();
        HashSet<FilePaths> paths = new HashSet<FilePaths>();
        Enumeration samplesUrls = Activator.getDefault().getBundle().findEntries(sampleDirPath, "*", true);
        if (samplesUrls != null) {
            while (samplesUrls.hasMoreElements()) {
                URL current = (URL)samplesUrls.nextElement();
                paths.add(new FilePaths(current, sampleDirName));
            }
        }
        return paths.toArray(new FilePaths[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, WasmSample> loadSamples(String bundleSamplesPath) {
        samples = new HashMap<String, WasmSample>();
        samplesUrls = Activator.getDefault().getBundle().findEntries(bundleSamplesPath, "*", false);
        if (samplesUrls != null) ** GOTO lbl16
        System.err.println("No samples directories found under the bundle's path: " + bundleSamplesPath);
        return samples;
lbl-1000:
        // 1 sources

        {
            sampleUrl = (URL)samplesUrls.nextElement();
            sampleFilesPaths = WasmSamples.getSampleFilesPaths(sampleUrl);
            try {
                sample = WasmSamples.loadSample(sampleFilesPaths);
                if (sample == null) continue;
                samples.put(sample.getName(), sample);
                continue;
            }
            catch (IOException | JsonNodeNotFoundException e) {
                e.printStackTrace();
            }
lbl16:
            // 4 sources

            ** while (samplesUrls.hasMoreElements())
        }
lbl17:
        // 1 sources

        return Collections.unmodifiableMap(samples);
    }

    public Map<String, WasmSample> getSamples() {
        return this.samples;
    }

    public static class FilePaths
    implements DeepCloneable {
        private final URL url;
        private final String relativeDestination;

        public FilePaths(URL fileUrl, String templatesPath) {
            this.url = fileUrl;
            String file = fileUrl.getFile();
            int templatesPathEnd = file.indexOf(templatesPath);
            if (templatesPathEnd == -1) {
                this.relativeDestination = file;
                return;
            }
            this.relativeDestination = file.substring(templatesPathEnd += templatesPath.length(), file.length());
        }

        public FilePaths(FilePaths other) throws MalformedURLException {
            this.url = new URL(other.url.toString());
            this.relativeDestination = new String(other.relativeDestination);
        }

        public Object deepClone() {
            try {
                return new FilePaths(this);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }

        public URL getUrl() {
            return this.url;
        }

        public String getRelativeDestinationPath() {
            return this.relativeDestination;
        }
    }

    private static class JsonNodeNotFoundException
    extends Exception {
        private static final long serialVersionUID = -7770778014086720067L;

        public JsonNodeNotFoundException(String message) {
            super(message);
        }
    }
}

