/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.tv.sec.launch.step.SecTVDebugInspectorOpenStep;
import org.tizen.web.tv.sec.launch.step.SecTVDebugStep;
import org.tizen.web.tv.sec.launch.step.SecTVDebugURLSettingStep;
import org.tizen.web.tv.sec.launch.step.SecTVInstallStep;
import org.tizen.web.tv.sec.launch.step.SecTVKillForDebugStep;
import org.tizen.web.tv.sec.launch.step.SecTVKillStep;
import org.tizen.web.tv.sec.launch.step.SecTVRdsStep;
import org.tizen.web.tv.sec.launch.step.SecTVRunStep;
import org.tizen.web.tv.sec.launch.step.SecTVTransferStep;
import org.tizen.web.tv.sec.launch.step.SecTVUnInstallStep;
import org.tizen.web.tv.sec.launch.step.SecTVUpdateStep;
import org.tizen.web.tv.sec.launch.step.SecTVWASUnInstallStep;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.deployer.StepFactory;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.step.DebugPortSettingStep;
import org.tizen.web.zimlaunch.step.RdsDeltaInputStep;
import org.tizen.web.zimlaunch.step.RdsStep;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class SecTVStepFactory
extends StepFactory {
    public PlatformCapability platformCapabilityChecker;

    public IStep createStep(ILaunchConfiguration config, String mode, boolean isInstalled) throws CoreException, ConfigurationException {
        try {
            this.platformCapabilityChecker = ConnectionPlugin.getDefault().getCurrentDevice().getPlatformCapability();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = config;
        this.mode = mode;
        IProject project = LaunchUtil.getProject((ILaunchConfiguration)config);
        if (project == null) {
            TizenWebIDEException.abort((String)LaunchMessages.PROJECT_NOT_FOUND, null, (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        Object fullstep = null;
        boolean isRdsMode = false;
        boolean isUpdateMode = config.getAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
        fullstep = !isInstalled ? new CompositeStep(new IStep[]{this.newPackageStep(), new SecTVTransferStep(), this.newInstallStep(), this.getRunOrDebugSteps(config, project, mode)}) : (SecTVStepFactory.needToFullInstall((ILaunchConfiguration)config, (IProject)project, (String)mode) ? this.getFullStep(project, mode) : (isUpdateMode && !isRdsMode ? new CompositeStep(new IStep[]{this.newPackageStep(), new SecTVTransferStep(), new SecTVUpdateStep(), this.getRunOrDebugSteps(config, project, mode)}) : (isRdsMode ? new CompositeStep(new IStep[]{new SecTVKillStep(), this.newRdsStep(), this.getRunOrDebugSteps(config, project, mode)}) : this.getFullStep(project, mode))));
        return fullstep;
    }

    private IStep getFullStep(IProject project, String mode) throws CoreException, ConfigurationException {
        CompositeStep fullstep = null;
        double productVer = Double.parseDouble(this.platformCapabilityChecker.getProductVersion());
        double onlyOneRWIPortVer = 1.0;
        double wasUninstallSupportVer = 2.1;
        fullstep = productVer == onlyOneRWIPortVer && "debug".equals(mode) ? new CompositeStep(new IStep[]{this.newPackageStep(), new SecTVTransferStep(), new SecTVKillForDebugStep(), new SecTVUnInstallStep(), this.newInstallStep(), this.getRunOrDebugSteps(this.config, project, mode)}) : (productVer >= wasUninstallSupportVer ? new CompositeStep(new IStep[]{this.newPackageStep(), new SecTVTransferStep(), new SecTVWASUnInstallStep(), new SecTVUnInstallStep(), this.newInstallStep(), this.getRunOrDebugSteps(this.config, project, mode)}) : new CompositeStep(new IStep[]{this.newPackageStep(), new SecTVTransferStep(), new SecTVUnInstallStep(), this.newInstallStep(), this.getRunOrDebugSteps(this.config, project, mode)}));
        return fullstep;
    }

    protected SecTVInstallStep newInstallStep() {
        return new SecTVInstallStep(new RdsDeltaInputStep());
    }

    protected SecTVDebugStep SecTVnewDebugStep() {
        return new SecTVDebugStep(null, null, null);
    }

    protected RdsStep newRdsStep() {
        return new SecTVRdsStep();
    }

    protected IStep getRunOrDebugSteps(ILaunchConfiguration config, IProject project, String mode) throws ConfigurationException, CoreException {
        CompositeStep steps = null;
        if (!LaunchUtil.canRun((IProject)project)) {
            return null;
        }
        if (config.getType().getName().equals("Tizen Web Unit Test")) {
            steps = new CompositeStep(new IStep[]{this.SecTVnewDebugStep()});
        } else if ("run".equals(mode)) {
            steps = new CompositeStep(new IStep[]{new SecTVRunStep()});
        } else if ("debug".equals(mode)) {
            steps = new CompositeStep(new IStep[]{this.getCommonDebugSteps()});
        }
        return steps;
    }

    protected IStep getCommonDebugSteps() {
        return new SecTVDebugStep(new DebugPortSettingStep(), new SecTVDebugURLSettingStep(), new SecTVDebugInspectorOpenStep());
    }
}

