/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.InstallStep;
import org.tizen.web.zimlaunch.step.RdsDeltaInputStep;

public class SecTVInstallStep
extends InstallStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVInstallStep.class);

    public SecTVInstallStep(RdsDeltaInputStep rdsDeltaInputStep) {
        super(rdsDeltaInputStep);
    }

    protected String makeRemoveCommand(String destDir, String packageFile) {
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = "";
        try {
            String removeFilePath = String.valueOf(destDir) + "/" + packageFile;
            cmd = secTVWRTCommandUtil.getCommand("RM_FILE_COMMAND", removeFilePath, this.resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    private int transferPackage(ZimLaunchResource resource) throws CoreException, IOException {
        int code = 0;
        SyncService service = null;
        try {
            IDevice device = resource.getDeviceinfo().getDevice();
            String destPath = TizenPlatformConstants.getAppTmpDirectory((IDevice)device);
            service = device.getSyncService();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String temp = String.valueOf(root.getLocation().toString()) + File.separator + resource.getAppinfo().getProject().getName() + File.separator + "aoc_app.zip";
            File checkFile = new File(temp);
            if (checkFile.exists()) {
                SyncResult syncSuccess = service.push(temp, device.getFileEntry(destPath).getParent());
                code = syncSuccess.getCode();
                if (!syncSuccess.isOk()) {
                    System.out.println("Code return is not ok...");
                }
            } else {
                code = 1;
            }
        }
        catch (Throwable throwable) {}
        return code;
    }

    protected boolean verifyAOC_app() {
        boolean ret = false;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String configFile = String.valueOf(root.getLocation().toString()) + File.separator + this.resource.getAppinfo().getProject().getName() + File.separator + "config.xml";
        File file = new File(configFile);
        try {
            String st;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((st = br.readLine()) != null) {
                System.out.println(st);
                if (!st.contains("http://samsung.com/tv/metadata/aoc_type.ch_feeder_standard")) continue;
                ret = true;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected void install(SdbCommand sdbCommand, int timeout) throws Exception {
        int ret;
        if (this.verifyAOC_app() && (ret = this.transferPackage(this.resource)) != 0) {
            return;
        }
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = secTVWRTCommandUtil.getCommand("INSTALL_COMMAND", null, this.resource);
        sdbCommand.runCommand(cmd);
    }
}

