/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import java.util.regex.Pattern;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.tv.sec.launch.util.jsconsole.Tizen24Pattern;
import org.tizen.web.tv.sec.launch.util.jsconsole.Tizen30Pattern;

public class LogPatternProvider {
    public static PlatformCapability platformCapabilityChecker;

    public static Pattern getLogPattern() {
        Pattern logPattern = Tizen30Pattern.getTVLogPattern();
        try {
            platformCapabilityChecker = ConnectionPlugin.getDefault().getCurrentDevice().getPlatformCapability();
            Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)ConnectionPlugin.getDefault().getCurrentDevice()));
            if (version.isSameOrBiggerThanVersion3()) {
                logPattern = Tizen30Pattern.getTVLogPattern();
            } else if (platformCapabilityChecker.getCpuArch().equals("x86") && platformCapabilityChecker.getProductVersion().equals("1.0")) {
                logPattern = Tizen24Pattern.getEmulatorLogPattern();
            } else if (version.compareTo(new Version("2.4")) == 0) {
                logPattern = Tizen24Pattern.getTVLogPattern();
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return logPattern;
    }

    public static Pattern getLogMsgPattern() {
        Pattern logMsgPattern = Tizen30Pattern.getLogMsgPattern();
        try {
            platformCapabilityChecker = ConnectionPlugin.getDefault().getCurrentDevice().getPlatformCapability();
            Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)ConnectionPlugin.getDefault().getCurrentDevice()));
            logMsgPattern = version.isSameOrBiggerThanVersion3() ? Tizen30Pattern.getLogMsgPattern() : Tizen24Pattern.getLogMsgPattern();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return logMsgPattern;
    }
}

