/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.web.tv.sec.launch.util.jsconsole.LogPatternProvider;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVDlogInfo;

public class SecTVDlogTimeParser {
    public PlatformCapability platformCapabilityChecker;

    public SecTVDlogInfo[] parseForSecTV(String ... lines) {
        Pattern logPattern = LogPatternProvider.getLogPattern();
        List<SecTVDlogInfo> infos = this.getSecTVDlogInfos(logPattern, lines);
        return infos.toArray(new SecTVDlogInfo[0]);
    }

    private List<SecTVDlogInfo> getSecTVDlogInfos(Pattern pattern, String ... lines) {
        String msgType = "ConsoleMessage";
        ArrayList<SecTVDlogInfo> infos = new ArrayList<SecTVDlogInfo>();
        try {
            Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)ConnectionPlugin.getDefault().getCurrentDevice()));
            SecTVDlogInfo info = null;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] matches;
                String line = stringArray[n2];
                if (line.length() > 0 && (matches = StringUtil.split((String)line, (Pattern)pattern)) != null) {
                    long deviceBootTime;
                    info = new SecTVDlogInfo();
                    if (version.isSameOrBiggerThanVersion3() && matches.length == 4) {
                        try {
                            SimpleDateFormat ft = new SimpleDateFormat("y-MM-dd hh:mm:ss");
                            Date date = ft.parse("1-" + matches[0]);
                            info.setCalendar(date);
                        }
                        catch (ParseException parseException) {}
                        deviceBootTime = this.getTizen30DeviceBootTimeInLog(matches[0]);
                        info.setDeviceBootTime(deviceBootTime);
                        info.setPid(Integer.parseInt(matches[2]));
                        String tagStr = matches[1];
                        String[] splitMsg = tagStr.split("/");
                        info.setTag(splitMsg[0]);
                        info.setLogLevel(LogLevel.getByLetter((String)splitMsg[0]));
                        if (msgType.matches(splitMsg[1])) {
                            info.setCommand(matches[3]);
                        } else {
                            String[] split2 = splitMsg[1].split("\\.");
                            String newCmd = "[" + split2[0] + "] " + matches[3];
                            info.setCommand(newCmd);
                        }
                        infos.add(info);
                    } else if (matches.length == 5) {
                        deviceBootTime = Long.parseLong(this.getTizen24DeviceBootTimeInLog(matches[0]));
                        info.setDeviceBootTime(deviceBootTime);
                        info.setLogLevel(LogLevel.getByLetter((String)matches[2]));
                        info.setTag(matches[2]);
                        info.setPid(Integer.parseInt(matches[3]));
                        info.setCommand(matches[4]);
                        infos.add(info);
                    }
                }
                ++n2;
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return infos;
    }

    private String getTizen24DeviceBootTimeInLog(String logText) {
        String deviceBootTime = "";
        Pattern pattern = Pattern.compile("\\d");
        Matcher match = pattern.matcher(logText);
        while (match.find()) {
            deviceBootTime = String.valueOf(deviceBootTime) + match.group(0);
        }
        return deviceBootTime.trim();
    }

    private long getTizen30DeviceBootTimeInLog(String logText) {
        long deviceBootTimeNumber = 0L;
        Pattern pattern = Pattern.compile("(0[0-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])");
        Matcher match = pattern.matcher(logText);
        int oneDaySec = 86400;
        int twentySevenDaySec = 2332800;
        int twentyNineDaySec = 2505600;
        int thirtyDaySec = 2592000;
        int oneHourSec = 3600;
        int oneMinSec = 60;
        int[] nArray = new int[14];
        nArray[2] = thirtyDaySec;
        nArray[3] = twentySevenDaySec;
        nArray[4] = thirtyDaySec;
        nArray[5] = twentyNineDaySec;
        nArray[6] = thirtyDaySec;
        nArray[7] = twentyNineDaySec;
        nArray[8] = thirtyDaySec;
        nArray[9] = thirtyDaySec;
        nArray[10] = twentyNineDaySec;
        nArray[11] = thirtyDaySec;
        nArray[12] = twentyNineDaySec;
        nArray[13] = thirtyDaySec;
        int[] monthSec = nArray;
        while (match.find()) {
            String month = match.group(1);
            String day = match.group(2);
            String hour = match.group(3);
            String min = match.group(4);
            String sec = match.group(5);
            deviceBootTimeNumber += (long)monthSec[Integer.parseInt(month)];
            int dayNum = Integer.parseInt(day) - 1;
            if (dayNum > 0) {
                deviceBootTimeNumber += (long)(oneDaySec * dayNum);
            }
            int hourNum = Integer.parseInt(hour) - 9;
            deviceBootTimeNumber += (long)(oneHourSec * hourNum);
            deviceBootTimeNumber += (long)(oneMinSec * Integer.parseInt(min));
            deviceBootTimeNumber += (long)Integer.parseInt(sec);
        }
        return deviceBootTimeNumber;
    }
}

