/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.console.TextConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.ui.view.console.ConsoleManager2;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogConsoleFactory;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogReceiver;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogThread;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogDocumentListener;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class SecTVJsLogConsoleManager
extends ConsoleManager2 {
    public static final Logger logger = LoggerFactory.getLogger(SecTVJsLogConsoleManager.class);
    private SecTVJsLogThread secTVjsLogThread = null;
    private JsLogDocumentListener documentListener;

    public SecTVJsLogConsoleManager(String consoleName, boolean focus) {
        super(consoleName, focus);
        this.addListener();
    }

    public void openConsole(IProject project, IDevice device, String packageID, JsLogReceiver receiver) throws IOException {
        logger.trace("open console({})", (Object)JsLogConsoleUtil.getConsoleName((IDevice)device));
        if (this.secTVjsLogThread != null) {
            this.secTVjsLogThread.close();
            this.secTVjsLogThread = null;
        }
        this.documentListener.setProject(project);
        receiver.setConsoleManager((ConsoleManager2)this);
        receiver.setPackageID(packageID);
        this.secTVjsLogThread = new SecTVJsLogThread(device, receiver);
        this.secTVjsLogThread.start();
        this.show();
    }

    public void openConsole(IProject project, IDevice device, String packageID, String serviceID, String appID, SecTVJsLogReceiver receiver) throws IOException {
        logger.trace("open console({})", (Object)JsLogConsoleUtil.getConsoleName((IDevice)device));
        if (this.secTVjsLogThread != null) {
            this.secTVjsLogThread.close();
            this.secTVjsLogThread = null;
        }
        this.documentListener.setProject(project);
        receiver.setConsoleManager(this);
        receiver.setPackageID(packageID);
        receiver.setServicePackageID(serviceID);
        receiver.setAppID(appID);
        if (this.secTVjsLogThread == null || !this.secTVjsLogThread.getPackageID().equals(packageID)) {
            this.secTVjsLogThread = new SecTVJsLogThread(device, receiver);
            this.secTVjsLogThread.start();
        } else if (this.secTVjsLogThread.getPackageID().equals(packageID)) {
            this.secTVjsLogThread.reStart();
        }
        this.show();
    }

    public void openConsole(IProject project, IDevice device, int pid, SecTVJsLogReceiver receiver) throws IOException {
        logger.trace("open console({})", (Object)JsLogConsoleUtil.getConsoleName((IDevice)device));
        if (this.secTVjsLogThread != null) {
            this.secTVjsLogThread.close();
            this.secTVjsLogThread = null;
        }
        this.documentListener.setProject(project);
        receiver.setConsoleManager(this);
        receiver.setPid(pid);
        this.secTVjsLogThread = new SecTVJsLogThread(device, receiver);
        this.secTVjsLogThread.start();
        this.show();
    }

    private void addListener() {
        IDeviceChangeListener[] listeners;
        IDeviceChangeListener[] iDeviceChangeListenerArray = listeners = SmartDevelopmentBridge.getBridge().getDeviceChangeListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IDeviceChangeListener listener = iDeviceChangeListenerArray[n2];
            if (listener instanceof SecTVJsLogConsoleSelectionListener) {
                return;
            }
            ++n2;
        }
        SecTVJsLogConsoleSelectionListener selectionListener = new SecTVJsLogConsoleSelectionListener();
        ConnectionPlugin.getDefault().addSelectionListener((ConnectionPlugin.ISelectionListener)selectionListener);
        this.documentListener = new JsLogDocumentListener((ConsoleManager2)this);
        ((TextConsole)this.getConsole()).getDocument().addDocumentListener((IDocumentListener)this.documentListener);
    }

    public void closeConsole() throws IOException {
        if (this.secTVjsLogThread != null) {
            this.secTVjsLogThread.close();
        }
    }

    private static class SecTVJsLogConsoleSelectionListener
    implements ConnectionPlugin.ISelectionListener {
        private SecTVJsLogConsoleSelectionListener() {
        }

        public void selectionChanged(FileEntry selectedEntry) {
            IDevice device;
            SecTVJsLogConsoleManager jlcm;
            if (selectedEntry != null && (jlcm = SecTVJsLogConsoleFactory.getConsoleManager(device = selectedEntry.getDevice())) != null) {
                jlcm.show(false);
            }
        }
    }
}

