#include <stdio.h>
#include <string.h>

#include "ppapi/c/pp_errors.h"
#include "ppapi/c/ppp.h"
#include "ppapi/c/ppp_instance.h"
#include "ppapi/c/ppp_messaging.h"
#include "ppapi/c/pp_bool.h"
#include "ppapi/c/ppb_var.h"
#include "ppapi/c/ppb_messaging.h"
#include "ppapi/c/pp_var.h"
#include "ppapi/c/ppb_var_array_buffer.h"

/**
 * This function is called by the browser when a new NaCl application instance
 * is created. Here your application starts it's action.
 * @see <code>DidCreate</code> in ppp_instance.h file.
 */
static PP_Bool Instance_DidCreate(PP_Instance instance, uint32_t argc,
                                  const char* argn[], const char* argv[]) {
  return PP_TRUE;
}

/**
 * Called when an instance is destroyed.
 * @see <code>DidDestroy</code> in ppp_instance.h file.
 */
static void Instance_DidDestroy(PP_Instance instance) {
}

/**
 * Called when instance view attributes has changed.
 * @see <code>DidChangeView</code> in ppp_instance.h file.
 */
static void Instance_DidChangeView(PP_Instance pp_instance, PP_Resource view) {
}

/**
 * Called when an instance gained or lost focus.
 * @see <code>DidChangeFocus</code> in ppp_instance.h file.
 */
static void Instance_DidChangeFocus(PP_Instance pp_instance, PP_Bool has_focus) {
}

/**
 * @see <code>HandleDocumentLoad</code> in ppp_instance.h file.
 */
static PP_Bool Instance_HandleDocumentLoad(PP_Instance pp_instance,
                                           PP_Resource pp_url_loader) {
  return PP_FALSE;
}

/**
 * This is an entry point to this nacl module. It's called while module is being
 * initialized. It's better not to do much here but interface pointers initialization.
 * With <code>get_browser_interface</code> you can get browser interfaces.
 * Implementation of this method is obligatory.
 * @see <code>PPP_InitializeModule</code> in ppp.h file.
 */
PP_EXPORT int32_t PPP_InitializeModule(PP_Module module_id,
                                       PPB_GetInterface get_browser_interface) {
  // Initializing pointers to used browser interfaces.
  g_messaging_interface = (const PPB_Messaging*) get_browser_interface(
      PPB_MESSAGING_INTERFACE);
  g_var_interface = (const PPB_Var*) get_browser_interface(PPB_VAR_INTERFACE);
  g_var_array_buffer_interface =
      (const PPB_VarArrayBuffer*) get_browser_interface(PPB_VAR_ARRAY_BUFFER_INTERFACE);

  return PP_OK;
}

/**
 * An implementation specific function for internal use only. It's better to
 * leave this method empty :)
 * Implementation of this method is obligatory.
 * @see <code>PPP_ShutdownModule</code> in ppp.h file.
 */
PP_EXPORT void PPP_ShutdownModule() {
}

/**
 * Handles messages from JS sent by <code>nacl_module.postMessage(...)</code>.
 * @see <code>HandleMessage()</code> in ppp_messaging.h file.
 */
void Messaging_HandleMessage(PP_Instance instance, struct PP_Var message) {
  // TODO: Add your communication NaCl<->JavaScript here:
  // g_messaging_interface->PostMessage(instance, );
  // You can also use Message Template Generator to generate functions automatically
  
}

/**
 * Browser uses this method to get implementation of interfaces that this module
 * supports.
 * Implementation of this method is also obligatory.
 * @see <code>PPP_GetInterface</code> in ppp.h file.
 */
PP_EXPORT const void* PPP_GetInterface(const char* interface_name) {

  if (strcmp(interface_name, PPP_INSTANCE_INTERFACE) == 0) {
    // Your module must fill this structure (interface) with proper order
    // (@see ppp.h file) and return it in this case.
    static PPP_Instance instance_interface = {
        &Instance_DidCreate,
        &Instance_DidDestroy,
        &Instance_DidChangeView,
        &Instance_DidChangeFocus,
        &Instance_HandleDocumentLoad
    };
    return &instance_interface;
  }
  if (strcmp(interface_name, PPP_MESSAGING_INTERFACE) == 0) {
    // To handle messages you have to implement PPP_Messaging interface and
    // return it as a pointer to this structure.
    static PPP_Messaging messaging_interface = {
        &Messaging_HandleMessage
    };
    return &messaging_interface;
  }
  return NULL;
}
