/**
 * Copyright (c) 2015, Samsung Electronics Co., Ltd
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Samsung Electronics nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @file example.js
 * @brief Example specific UI configuration.
 * Variables below will configure this demo example for it needs after document
 * load finishes.
 * @see common.js for more details.
 */

var demo_name = "Input Events";
var demo_description = "This demo presents input events handling. " +
		"Embeded element needs to have focus for this demo to work. " +
		"If focus is lost please click inside the blue rectangle." +
		"This demo will print log messages on mouse movement, mouse clicks," +
		" mouse wheel rotation, and keyboard button strokes.";
var nmf_path_name = "<nmf_file>";
var nacl_width = 100;         // NaCl module view width and height in pixels.
var nacl_height = 100;
var uses_logging = true;   // If "false" - hides logs area on the HTML page.

function exampleSpecificActionAfterNaclLoad() {
  var nacl_module = document.getElementById("nacl_module");
  nacl_module.focus();
  nacl_module.style.border = "thick solid #0000FF";
}
