NaCl Hello World in C
=====================

This is an example of a Hello World NaCl application implemented in C.
It launches a NaCl module that waits for a string type message form JavaScript
and sends back an echo message.


### Shows how to:
* implement a NaCl plugin in C
* send a text message from NaCl to JavaScript

### Requirements:
* pepper_42 or newer

### Files description:
* `config.xml`

    A Samsung Tizen TV widget manifest file. For more info search
    www.samsungdforum.com for config.xml in TizenTV:
    [link](http://www.samsungdforum.com/tizenguide/?Foldername=tizen151&Filename=index.html).

* `src/hello_world.c`

    A NaCl C application source file. It contains code that is essential to
    launch a NaCl module written in C and handles simple messaging communication
    with JavaScript.

* `hello_world_c.nmf`

    A NaCl application manifest file.
    A JSON file that points to a binary file depending on a processor
    architecture. Also it shall contain a permissions request if a NaCl
    application wants to use some non public Pepper API (like `*_Dev`,
    `*_Samsung`, `*_Private`).
    See [here](https://developer.chrome.com/native-client/devguide/coding/application-structure#manifest-files).
    Note: This file is generated by NaCl toolchain when building a NaCl project.

* `hello_world_c.*.nexe`

    A NaCl application binaries for a specific processor architecture (arm,
    x86 32 and 64 bit).
    These binaries are built by a NaCl toolchain when the project is built from
    Samsung TizenTV SDK IDE, or you may compile them from CLI using make command.
    More info [here](https://developer.chrome.com/native-client/devguide/devcycle/building).
    Note: Samsung Tizen TVs don't support pnacl files actually, only nexe
    binaries for ARM architecture. For release version there is no
    need to include binaries for any other architecture.

* `index.html`

    An entry point to this Web Application - an HTML Web Page file that loads a
    NaCl plugin.

