/* Handles messages sent from a NaCl module by PostMessage(). */
function handleMessage(message) {
  document.getElementById("nacl_output").innerHTML += message.data;
}

/* An utility function. */
function updateStatus(txt_message) {
  document.getElementById("status").innerHTML = txt_message;
}

function handleLoad(event) {
  updateStatus("Loaded");
  var nacl_module = document.getElementById("nacl_module");
  nacl_module.postMessage("Hello World from JS");
}

function handleCrash(event) {
  updateStatus("Crashed/exited with status: " + nacl_module.exitStatus);
}

/**
 * Configure this page with example specific elements when document finishes
 * loading.
 */
document.addEventListener("DOMContentLoaded", function () {
  var listenerDiv = document.getElementById("listener");
  var nacl_module = document.getElementById("nacl_module");
  /* Here we bind events specific for an "application/x-nacl" type embed element.
  for more info see:
  https://developer.chrome.com/native-client/devguide/coding/progress-events .*/
  listenerDiv.addEventListener("message", handleMessage, true);
  listenerDiv.addEventListener("load", handleLoad, true);
  listenerDiv.addEventListener("crash", handleCrash, true);
});