/**
 * Copyright (c) 2013 The Chromium Authors. All rights reserved.
 * Copyright (c) 2015, Samsung Electronics Co., Ltd. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Google Inc, Samsung Electronics nor the names of
 *    its contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SOCKETS_SRC_NET_UTILS_H_
#define SOCKETS_SRC_NET_UTILS_H_

#include <string>
#include <stdint.h>

// Implement htons locally. Even though this is provided by
// nacl_io we don't want to include nacl_io in this simple
// example.

uint16_t Htons(uint16_t hostshort);

/**
 * Divides provided by user string describing destination
 * to hostname and port. If port information is missing
 * then it will use by default value 80 to it.
 * For example:
 * host=0.0.0.0:30    -> hostname=0.0.0.0 port=30
 * host=10.0.0.20     -> hostname=10.0.0.20 port=80
 * host=google.com    -> hostname=google.com port=80
 * host=myserv.net:20 -> hostname=myserv.net port=20
 *
 * @param [in] host Represents domain name or IP.
 * @param [in] default_port Used in case of missing information in "host" parameter.
 * @param [out] port Port number parsed out from host.
 * @param [out] hostname A host without port.
 */
void ParseHost(const std::string& host,
                      const int& default_port,
                      int& port,
                      std::string& hostname);

#endif  // SOCKETS_SRC_NET_UTILS_H_
