/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.add_wasm_module.wizard;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BooleanSupplier;
import org.eclipse.jface.wizard.WizardPage;

public class WizardPageErrorChecker<ErrorType, PageType extends WizardPage> {
    private final PageType parent;
    private final Deque<ErrorType> errorStack = new ArrayDeque<ErrorType>();

    public WizardPageErrorChecker(PageType parentPage) {
        this.parent = parentPage;
    }

    public boolean checkForError(ErrorType error, BooleanSupplier errorChecker) {
        if (error == null || errorChecker == null) {
            return false;
        }
        boolean ret = false;
        if (errorChecker.getAsBoolean()) {
            ret = true;
            this.errorStack.addFirst(error);
        } else if (!this.errorStack.isEmpty()) {
            while (this.errorStack.remove(error)) {
            }
        }
        if (!this.errorStack.isEmpty()) {
            this.parent.setErrorMessage(this.errorStack.peekFirst().toString());
            this.parent.setPageComplete(false);
        } else {
            this.parent.setErrorMessage(null);
            this.parent.setPageComplete(true);
        }
        return ret;
    }
}

