/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.project.merger;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.tizen.web.tv.sec.wasm.common.GeneralTools;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.project.IProjectData;
import org.tizen.web.tv.sec.wasm.project.WasmModuleLayout;
import org.tizen.web.tv.sec.wasm.project.merger.Messages;
import org.tizen.web.tv.sec.wasm.project.merger.Utils;

public class WasmModuleInserter {
    private static final String TIZEN_PROJECT_INDEX_HTML = "index.html";
    private static final String TIZEN_PROJECT_STYLE_CSS = "css" + File.separator + "style.css";
    private static final String TIZEN_SCRIPTS_DIR = "wasm_modules" + File.separator + "scripts" + File.separator + "wasm_tools.js";
    private static final String BUNDLE_CSS_DIV_FILE = "/resources/css/module_div.css";
    private static final String BUNDLE_CSS_CANVAS_FILE = "/resources/css/module_canvas.css";
    private static final String BUNDLE_CSS_TEXTAREA_FILE = "/resources/css/module_textarea.css";
    private static final String BUNDLE_SCRIPT_FILE = "/resources/scripts/wasm_helpers.js";
    private static final String BUNDLE_HTML_FILE = "/resources/html/module_embed_code.html";
    private static final String WASM_TOOLS_JS = "wasm_modules/scripts/wasm_tools.js";
    private static final String WASM_TOOLS_ELEMENT = "<script src=\"wasm_modules/scripts/wasm_tools.js\"></script>";
    private static final String CANVAS_ELEMENT = "document.getElementById('[##ModuleName##]_canvas')";
    private static final String TEXTAREA_ELEMENT = "document.getElementById('[##ModuleName##]_output')";

    public static void insertWasmModule(IProjectData wasmProjectData, IProject tizenProject, IProgressMonitor monitor) throws CoreException {
        if (wasmProjectData == null || tizenProject == null) {
            Logger.getLogger("org.tizen.web.tv.sec.wasm").severe("Invalid project data or(and) project");
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WasmModuleInserter_MergingWasmModuleWithTizenProject, (int)100);
        String tizenProjectPath = tizenProject.getLocation().toOSString();
        String moduleName = wasmProjectData.getName();
        WasmModuleLayout.Canvas canvas = null;
        WasmModuleLayout.TextArea textarea = null;
        WasmModuleLayout layout = wasmProjectData.getSampleData().getLayout();
        if (layout != null) {
            canvas = layout.getCanvas();
            textarea = layout.getTextArea();
        }
        TizenProjectCssMerger.adjustCssFile(tizenProjectPath, moduleName, canvas != null, textarea != null);
        progress.split(10);
        TizenProjectHtmlMerger.adjustHtmlFile(tizenProjectPath, moduleName, canvas, textarea);
        progress.split(10);
        tizenProject.refreshLocal(2, (IProgressMonitor)progress.split(80));
    }

    private static class TizenProjectCssMerger {
        private TizenProjectCssMerger() {
        }

        private static void adjustCssFile(String tizenProjectPath, String moduleName, boolean isCanvasRequired, boolean isTextareaRequired) {
            String tizenProjectCssPath = String.valueOf(tizenProjectPath) + File.separator + TIZEN_PROJECT_STYLE_CSS;
            StringBuilder css = new StringBuilder();
            TizenProjectCssMerger.addFileContent(css, new File(tizenProjectCssPath));
            TizenProjectCssMerger.addBundleFileContent(css, WasmModuleInserter.BUNDLE_CSS_DIV_FILE);
            if (isCanvasRequired) {
                TizenProjectCssMerger.addBundleFileContent(css, WasmModuleInserter.BUNDLE_CSS_CANVAS_FILE);
            }
            if (isTextareaRequired) {
                TizenProjectCssMerger.addBundleFileContent(css, WasmModuleInserter.BUNDLE_CSS_TEXTAREA_FILE);
            }
            String cssContent = css.toString().replace("[##ModuleName##]", moduleName);
            ProjectUtils.saveContentToFile((String)tizenProjectCssPath, (String)cssContent);
        }

        private static void addBundleFileContent(StringBuilder str, String fileName) {
            TizenProjectCssMerger.addFileContent(str, Utils.getBundleFile(fileName));
        }

        private static void addFileContent(StringBuilder str, File file) {
            str.append(GeneralTools.getFileContent((File)file));
            str.append(System.lineSeparator());
        }
    }

    private static class TizenProjectHtmlMerger {
        private TizenProjectHtmlMerger() {
        }

        private static void adjustHtmlFile(String tizenProjectPath, String moduleName, WasmModuleLayout.Canvas canvas, WasmModuleLayout.TextArea textarea) {
            HashMap<String, String> map;
            File bundleHtmlFile = Utils.getBundleFile(WasmModuleInserter.BUNDLE_HTML_FILE);
            if (bundleHtmlFile == null) {
                System.err.println("No file found under the bundle's path: /resources/html/module_embed_code.html");
                return;
            }
            String htmlPath = String.valueOf(tizenProjectPath) + File.separator + WasmModuleInserter.TIZEN_PROJECT_INDEX_HTML;
            Document indexDoc = ProjectUtils.parseFile((File)new File(htmlPath));
            Document bundleDoc = ProjectUtils.parseFile((File)bundleHtmlFile);
            if (indexDoc == null || bundleDoc == null) {
                System.err.println("Failed to parse file(s) into document");
                return;
            }
            if (!TizenProjectHtmlMerger.elementAttributeExist(indexDoc, "src", WasmModuleInserter.WASM_TOOLS_JS)) {
                TizenProjectHtmlMerger.appendToHeadElement(indexDoc, WasmModuleInserter.WASM_TOOLS_ELEMENT);
                TizenProjectHtmlMerger.copyFileFromBundle(WasmModuleInserter.BUNDLE_SCRIPT_FILE, String.valueOf(tizenProjectPath) + File.separator + TIZEN_SCRIPTS_DIR);
            }
            if (canvas == null) {
                TizenProjectHtmlMerger.removeElementWithAttr(bundleDoc, "id", "[##ModuleName##]_canvas");
                TizenProjectHtmlMerger.modifyElementText(bundleDoc.getElementsByTag("script").last(), WasmModuleInserter.CANVAS_ELEMENT, "null");
            } else {
                map = new HashMap<String, String>();
                map.put("width", String.valueOf(canvas.getWidth()));
                map.put("height", String.valueOf(canvas.getHeight()));
                TizenProjectHtmlMerger.addDocumentElementAttributes(bundleDoc, "canvas", map);
            }
            if (textarea == null) {
                TizenProjectHtmlMerger.removeElementWithAttr(bundleDoc, "id", "[##ModuleName##]_output");
                TizenProjectHtmlMerger.modifyElementText(bundleDoc.getElementsByTag("script").last(), WasmModuleInserter.TEXTAREA_ELEMENT, "null");
            } else {
                map = new HashMap();
                map.put("cols", String.valueOf(textarea.getColumnCount()));
                map.put("rows", String.valueOf(textarea.getRowCount()));
                TizenProjectHtmlMerger.addDocumentElementAttributes(bundleDoc, "textarea", map);
            }
            String htmlContent = bundleDoc.toString().replace("[##ModuleName##]", moduleName);
            TizenProjectHtmlMerger.appendToBodyElement(indexDoc, htmlContent);
            ProjectUtils.saveContentToFile((String)htmlPath, (String)indexDoc.toString());
        }

        private static void addDocumentElementAttributes(Document document, String tag, HashMap<String, String> map) {
            if (document == null) {
                return;
            }
            Elements elements = document.getElementsByTag(tag);
            if (!elements.isEmpty()) {
                TizenProjectHtmlMerger.addElementAttributes((Element)elements.get(0), map);
            }
        }

        private static void addElementAttributes(Element element, HashMap<String, String> map) {
            if (element == null || map == null) {
                return;
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                element.attr(entry.getKey(), entry.getValue());
            }
        }

        private static void copyFileFromBundle(String source, String destination) {
            File sourceFile = Utils.getBundleFile(source);
            if (sourceFile == null) {
                System.err.println("No file found under the bundle's path: " + source);
                return;
            }
            File destinationFile = new File(destination);
            File parentFolder = destinationFile.getParentFile();
            if (parentFolder != null && parentFolder.mkdirs()) {
                try {
                    Files.copy(sourceFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private static void modifyElementText(Element element, String replaced, String replacement) {
            if (element == null) {
                return;
            }
            for (DataNode node : element.dataNodes()) {
                node.setWholeData(node.getWholeData().replace(replaced, replacement));
            }
        }

        private static void appendToBodyElement(Document doc, String element) {
            doc.body().append(element);
        }

        private static void appendToHeadElement(Document doc, String element) {
            doc.head().append(element);
        }

        private static boolean elementAttributeExist(Document doc, String attrName, String attrValue) {
            if (doc == null || attrName == null || attrValue == null) {
                return false;
            }
            Elements elements = doc.getElementsByAttributeValue(attrName, attrValue);
            return !elements.isEmpty();
        }

        private static void removeElementWithAttr(Document doc, String attrName, String attrValue) {
            if (doc == null || attrName == null || attrValue == null) {
                return;
            }
            Elements elements = doc.getElementsByAttributeValue(attrName, attrValue);
            for (Element e : elements) {
                e.remove();
            }
        }
    }
}

