/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.simulator.standalone.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.common.CommonMessages;
import org.tizen.web.tv.sec.simulator.standalone.SimulatorPlugin;
import org.tizen.web.tv.sec.simulator.standalone.launch.Messages;

public class SimulatorMainTab
extends AbstractLaunchConfigurationTab {
    public static final String PROJECT_NAME = "project_name";
    public static final String PROJECT_NAME_KEY = "org.tizen.web.common.project";
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(Messages.PROJECT_NAME);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimulatorMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, CommonMessages.Dialog_browse, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SimulatorMainTab.this.handleProjectButtonSelected();
                SimulatorMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        this.fProjText.setText(project.getName());
    }

    private IProject chooseProject() {
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(Messages.SimulatorMainTab_TITLE);
        dialog.setMessage(Messages.SimulatorMainTab_MESSAGE);
        dialog.setElements(projects);
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    public String getName() {
        return Messages.MAINTAB;
    }

    public Image getImage() {
        return ImageUtil.getImage((Plugin)SimulatorPlugin.getDefault(), (String)Messages.SimulatorMainTab_image);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectFromConfig(configuration);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            IStructuredSelection sel;
            Object res;
            ISelection selection;
            projectName = config.getAttribute(PROJECT_NAME_KEY, "");
            if (projectName.length() == 0 && (selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection()) instanceof IStructuredSelection && (res = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                projectName = ((IResource)res).getProject().getName();
            }
        }
        catch (CoreException coreException) {}
        this.fProjText.setText(projectName);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(Messages.PROJECT_NOT_SPECIFIED);
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(CommonMessages.Project_does_not_exist);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isOpen()) {
            this.setErrorMessage(Messages.PROJECT_MUST_BE_OPENED);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(PROJECT_NAME_KEY, this.fProjText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(PROJECT_NAME_KEY, "");
    }
}

