/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.preferences;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferenceActivator;

public abstract class WasmPreferences {
    private static final String PREFERENCES_NODE_NAME = "org.tizen.web.tv.sec.wasm.preferences";
    private static final String PREFERENCES_NODE_EM_CONFIG = "emscripten_config_file";
    private static final String PREFERENCES_NODE_EM_CACHE = "emscripten_cache_dir";
    public static final String HOME_DIR = System.getProperty("user.home");
    public static final String EM_CONFIG_DEFAULT_PATH = String.valueOf(HOME_DIR) + File.separator + ".emscripten";
    public static final String EM_CACHE_DEFAULT_PATH = String.valueOf(HOME_DIR) + File.separator + ".emscripten_cache";

    private static String getPreference(IProject project, String preferenceNodeName, String defaultValue) throws PreferencesOperationException {
        Preferences preferences = WasmPreferences.getProjectPreferences(project);
        return preferences.get(preferenceNodeName, defaultValue);
    }

    public static String getEmscriptenCachePath(IProject project) throws PreferencesOperationException {
        return WasmPreferences.getPreference(project, PREFERENCES_NODE_EM_CACHE, "");
    }

    public static String getEmscriptenConfigPath(IProject project) throws PreferencesOperationException {
        return WasmPreferences.getPreference(project, PREFERENCES_NODE_EM_CONFIG, "");
    }

    private static void storePreference(IProject project, String preferenceNodeName, String value, IProgressMonitor monitor) throws PreferencesOperationException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences preferences = WasmPreferences.getProjectPreferences(project);
        preferences.put(preferenceNodeName, value);
        try {
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new PreferencesOperationException("Failed to store the toolchain binaries path preference for the project: " + project.getName(), e);
            }
        }
        finally {
            progress.split(100);
        }
    }

    public static void storeEmscriptenConfigPath(IProject project, String path, IProgressMonitor monitor) throws PreferencesOperationException {
        WasmPreferences.storePreference(project, PREFERENCES_NODE_EM_CONFIG, path, monitor);
    }

    public static void storeEmscriptenCachePath(IProject project, String path, IProgressMonitor monitor) throws PreferencesOperationException {
        WasmPreferences.storePreference(project, PREFERENCES_NODE_EM_CACHE, path, monitor);
    }

    private static Preferences getProjectPreferences(IProject project) throws PreferencesOperationException {
        if (project == null) {
            throw new PreferencesOperationException("Null project passed");
        }
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences preferences = projectScope.getNode(PREFERENCES_NODE_NAME);
        if (preferences == null) {
            throw new PreferencesOperationException("Failed to get the preferences node: org.tizen.web.tv.sec.wasm.preferences for the project: " + project.getName());
        }
        return preferences;
    }

    public static String getEmscriptenConfigPath() {
        IPreferenceStore preferenceStore = WasmPreferenceActivator.getDefault().getPreferenceStore();
        return preferenceStore.getString("emscripten.config");
    }

    public static String getEmscriptenCachePath() {
        IPreferenceStore preferenceStore = WasmPreferenceActivator.getDefault().getPreferenceStore();
        return preferenceStore.getString("emscripten.cache");
    }

    public static void storeEmscriptenConfigPath(String path) {
        IPreferenceStore preferenceStore = WasmPreferenceActivator.getDefault().getPreferenceStore();
        preferenceStore.setValue("emscripten.config", path);
    }

    public static void storeEmscriptenCachePath(String path) {
        IPreferenceStore preferenceStore = WasmPreferenceActivator.getDefault().getPreferenceStore();
        preferenceStore.setValue("emscripten.cache", path);
    }

    public static class PreferencesOperationException
    extends CoreException {
        private static final long serialVersionUID = -4001073672010456834L;

        public PreferencesOperationException(String message) {
            super((IStatus)new Status(4, WasmPreferences.class.getPackage().getName(), message));
        }

        public PreferencesOperationException(String message, Throwable exception) {
            super((IStatus)new Status(4, WasmPreferences.class.getPackage().getName(), message, exception));
        }
    }
}

