/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.simulator.standalone.launch;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.tizen.web.tv.sec.simulator.standalone.launch.Messages;
import org.tizen.web.tv.sec.simulator.standalone.launch.SimulatorLauncher;
import org.tizen.web.tv.sec.util.Util;

public class SimulatorApplicationDelegate
extends LaunchConfigurationDelegate {
    private IProject[] fOrderedProjects;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject(configuration);
        IFile file = SimulatorLauncher.getContentFile(project);
        if (file == null) {
            throw new CoreException((IStatus)Util.errorStatus((String)Messages.msgErrConfigurationFile, (String)"org.tizen.web.tv.sec.simulator.standalone"));
        }
        try {
            URL url = file.getLocationURI().toURL();
            SimulatorLauncher.launch(url, project);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CoreException((IStatus)Util.errorStatus((String)Messages.msgErrURLConversion, (String)"org.tizen.web.tv.sec.simulator.standalone"));
        }
    }

    private IProject getProject(ILaunchConfiguration config) throws CoreException {
        String projectName = config.getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", null);
        if (projectName != null && !projectName.equals("")) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.fOrderedProjects = null;
        IProject currentProject = this.getProject(configuration);
        if (currentProject != null) {
            this.fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{currentProject.getProject()});
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }
}

