/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.simulator.standalone.launch;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.OSChecker;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.tv.sec.simulator.standalone.SimulatorPlugin;
import org.tizen.web.tv.sec.util.OSUtil;
import org.tizen.web.tv.sec.util.Util;

public class SimulatorLauncher {
    static final String ARG_APP_KEY = "--app";
    static final String ARG_PLATFORM_KEY = "--platform";
    static final String ARG_PLATFORM_VALUE = "tizentv";
    static final String ARG_VERSION_KEY = "--tizentvversion";
    static final String ARG_VERSION_VALUE = "2.0";
    static final String ARG_RESOLUTION_KEY = "--resolution";
    static final String ARG_RESOLUTION_VALUE = "1920X1080";
    static final String ARG_FILE_KEY = "--file";
    static final String SIMULATOR_FOLDER = "sec-tv-simulator";
    static final String SIMULATOR_EXECUTABLE = "simulator";
    static final String SIMULATOR_EXECUTABLE_MAC = "nwjs";
    static final List<String> DEFAULT_INDEXHTML_NAMES = Arrays.asList("index.html", "index.htm", "index.xhtml", "index.xht");

    public static Process launch(URL url, IProject project) throws CoreException {
        try {
            String prefix = "file://";
            String slocation = SimulatorLauncher.getSimulator();
            if (OSUtil.isMAC() && slocation != null && !slocation.isEmpty()) {
                slocation = String.valueOf(slocation) + File.separator + "Contents" + File.separator + "MacOS" + File.separator + SIMULATOR_EXECUTABLE_MAC;
            }
            List<String> cmd = null;
            if (OSUtil.isLinux() || OSUtil.isMAC()) {
                prefix = "file:///";
                cmd = SimulatorLauncher.createCommandArgs(project, String.valueOf(prefix) + url.getPath(), slocation);
            } else {
                cmd = SimulatorLauncher.createCommandArgs(project, String.valueOf('\"') + prefix + url.getPath() + '\"', slocation);
            }
            ProcessBuilder builder = new ProcessBuilder(cmd);
            Process proc = builder.start();
            return proc;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)Util.errorStatus((String)e.getLocalizedMessage(), (String)"org.tizen.web.tv.sec.simulator.standalone"));
        }
    }

    protected static List<String> createCommandArgs(IProject project, String url, String slocation) {
        ArrayList<String> command = new ArrayList<String>();
        if (OSChecker.isWindows()) {
            command.add("cmd.exe");
            command.add("/C");
        }
        command.add(slocation);
        if (OSUtil.isLinux() || OSUtil.isMAC()) {
            command.add("--app=" + project.getName());
        } else {
            command.add("--app=\"" + project.getName() + '\"');
        }
        command.add("--platform=tizentv");
        command.add("--tizentvversion=2.0");
        command.add("--resolution=1920X1080");
        command.add("--file=" + url);
        return command;
    }

    public static IFile getContentFile(IProject project) throws CoreException {
        IFile indexhtml_file = null;
        if (project == null) {
            return null;
        }
        ITizenConfigurator tmpConfigurator = null;
        String indexhtml_path = null;
        try {
            tmpConfigurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
            indexhtml_path = tmpConfigurator.getContentSrc();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        if (indexhtml_path != null) {
            indexhtml_file = project.getFile(indexhtml_path);
        } else {
            for (String pathi : DEFAULT_INDEXHTML_NAMES) {
                indexhtml_file = project.getFile(pathi);
                if (indexhtml_file.exists()) break;
            }
            if (indexhtml_file == null) {
                IResource[] iResourceArray = project.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource file = iResourceArray[n2];
                    if (file instanceof IFile && DEFAULT_INDEXHTML_NAMES.contains(file.getName().toLowerCase(Locale.ENGLISH))) {
                        indexhtml_file = (IFile)file;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (indexhtml_file != null && indexhtml_file.exists()) {
            return indexhtml_file;
        }
        return null;
    }

    public static String getDefaultSimulator() {
        String toolsPath = InstallPathConfig.getToolsPath();
        StringBuilder sb = new StringBuilder(50);
        sb.append(toolsPath);
        sb.append(File.separator);
        sb.append(SIMULATOR_FOLDER);
        sb.append(File.separator);
        String execut = SIMULATOR_EXECUTABLE;
        String extension = "";
        if (OSChecker.isWindows()) {
            extension = ".exe";
        } else if (OSChecker.isMAC()) {
            execut = SIMULATOR_EXECUTABLE_MAC;
            extension = ".app";
        }
        sb.append(execut).append(extension);
        return sb.toString();
    }

    public static String getSimulator() {
        IPreferenceStore store = SimulatorPlugin.getDefault().getPreferenceStore();
        String spath = store.getString("simulator_path");
        if (spath == null) {
            return SimulatorLauncher.getDefaultSimulator();
        }
        return spath;
    }

    public static String[] getSimulatorFileExtension() {
        if (OSChecker.isWindows()) {
            return new String[]{"*.exe"};
        }
        if (OSChecker.isMAC()) {
            return new String[]{"*.app"};
        }
        return new String[0];
    }
}

