/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.tizen.web.tv.sec.wasm.common.NativeLanguage;
import org.tizen.web.tv.sec.wasm.common.plugin.Messages;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferences;
import org.tizen.web.tv.sec.wasm.project.IProjectData;
import org.tizen.web.tv.sec.wasm.project.WasmSample;
import org.tizen.web.tv.sec.wasm.project.WasmSamples;

public class ProjectFactory {
    private static final Map<NativeLanguage, String[]> NATURES = Collections.unmodifiableMap(new HashMap<NativeLanguage, String[]>(){
        private static final long serialVersionUID = -2726305834663007861L;
        {
            this.put(NativeLanguage.C, new String[]{"org.tizen.web.tv.sec.wasm.common.plugin.WasmProjectNature", "org.eclipse.cdt.managedbuilder.core.managedBuildNature", "org.eclipse.cdt.managedbuilder.core.ScannerConfigNature", "org.eclipse.cdt.core.cnature"});
            this.put(NativeLanguage.CPP, new String[]{"org.tizen.web.tv.sec.wasm.common.plugin.WasmProjectNature", "org.eclipse.cdt.managedbuilder.core.managedBuildNature", "org.eclipse.cdt.managedbuilder.core.ScannerConfigNature", "org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"});
        }
    });

    private static IProject createBaseProject(String projectName, String projectPath, NativeLanguage language, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreatingProject, (int)100);
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Assert.isNotNull((Object)newProject);
        if (newProject.exists()) {
            throw new CoreException((IStatus)new Status(2, ProjectFactory.class.getPackage().getName(), String.valueOf(Messages.FailedToCreateProject) + projectName + Messages.ProjectAlreadyExists));
        }
        IProjectDescription description = newProject.getWorkspace().newProjectDescription(newProject.getName());
        IPath projectLocation = projectPath != null ? new Path(projectPath).append(projectName) : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectName);
        description.setLocation(projectLocation);
        description.setNatureIds(NATURES.get(language));
        ProjectFactory.setBuildSpec(description);
        progress.split(20);
        newProject.create(description, (IProgressMonitor)progress.split(40));
        if (!newProject.isOpen()) {
            newProject.open((IProgressMonitor)progress.split(40));
        }
        return newProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void copyFile(URL source, File destination) throws IOException {
        if (source.getFile().endsWith("/")) {
            return;
        }
        destination.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ReadableByteChannel inputChannel = Channels.newChannel(source.openStream());
            try {
                try (FileOutputStream targetStream = new FileOutputStream(destination);){
                    targetStream.getChannel().transferFrom(inputChannel, 0L, Long.MAX_VALUE);
                }
                if (inputChannel == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputChannel == null) throw throwable;
                inputChannel.close();
                throw throwable;
            }
            inputChannel.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void createProjectContent(IProjectData projectData, IProgressMonitor monitor) {
        WasmSamples.FilePaths[] filesPaths = projectData.getSampleData().getSampleFilesPaths();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreatingContent, (int)filesPaths.length);
        WasmSamples.FilePaths[] filePathsArray = filesPaths;
        int n = filesPaths.length;
        int n2 = 0;
        while (n2 < n) {
            WasmSamples.FilePaths filePaths = filePathsArray[n2];
            File destination = Paths.get(projectData.getPath(), projectData.getName(), filePaths.getRelativeDestinationPath()).toFile();
            try {
                if (filePaths.getUrl().getFile().endsWith("settings.json")) {
                    progress.split(1);
                } else {
                    ProjectFactory.copyFile(filePaths.getUrl(), destination);
                    progress.split(1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private static void addManagedBuilder(IProject project, IProjectData projectData, IProgressMonitor monitor) throws CoreException, BuildException {
        IConfiguration[] buildConfigs;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreatingBuildConfigurations, (int)100);
        ICProjectDescription description = CoreModel.getDefault().createProjectDescription(project, true);
        IProjectType projType = ManagedBuildManager.getExtensionProjectType((String)"org.tizen.web.tv.sec.wasm.builder.toolchain");
        ManagedBuildManager.createBuildInfo((IResource)project);
        IManagedProject managedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        IConfiguration[] iConfigurationArray = buildConfigs = projType.getConfigurations();
        int n = buildConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration icf = iConfigurationArray[n2];
            String id = ManagedBuildManager.calculateChildId((String)icf.getId(), null);
            IConfiguration config = managedProject.createConfiguration(icf, id);
            config.setArtifactName("${ProjName}");
            IBuilder builder = config.getEditableBuilder();
            if (builder != null) {
                builder.setManagedBuildOn(true);
            }
            WasmSample.BuildConfiguration wasmBuildConfig = projectData.getSampleData().getBuildConfiguration(config.getName());
            ProjectFactory.addBuildOptions(config, wasmBuildConfig);
            ICConfigurationDescription cconfig = description.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", config.getConfigurationData());
            try {
                ProjectUtils.resetEmscriptenConfig((ICConfigurationDescription)cconfig, (String)projectData.getEmscriptenConfigData().getConfigFilePath(), (String)projectData.getEmscriptenConfigData().getCacheDirPath());
            }
            catch (CoreException coreException) {
                project.delete(true, (IProgressMonitor)progress);
                throw new CoreException((IStatus)new Status(4, ProjectFactory.class.getPackage().getName(), String.valueOf(Messages.FailedToCreateProject) + project.getName() + "\". " + Messages.FailedToReadEmscriptenConfig + projectData.getEmscriptenConfigData().getConfigFilePath()));
            }
            ++n2;
        }
        ICProjectDescriptionManager mgr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescriptionWorkspacePreferences prefs = mgr.getProjectDescriptionWorkspacePreferences(true);
        prefs.setConfigurationRelations(2);
        mgr.setProjectDescriptionWorkspacePreferences(prefs, true, null);
        CoreModel.getDefault().setProjectDescription(project, description);
        progress.split(100);
    }

    private static Object newOptions(IOption option, String[] optionsToAppend) throws BuildException {
        if (option.getValueType() == 3) {
            String[] existingOptions = option.getStringListValue();
            String[] newOptions = (String[])Stream.concat(Arrays.stream(existingOptions), Arrays.stream(optionsToAppend)).toArray(String[]::new);
            return newOptions;
        }
        if (option.getValueType() == 2) {
            String existingOptions = option.getStringValue();
            String newOptions = String.valueOf(existingOptions) + " " + Arrays.stream(optionsToAppend).reduce("", (a, b) -> String.valueOf(a) + " " + b);
            return newOptions;
        }
        return null;
    }

    private static void updateModuleExportName(String name, String[] linkerOptions) {
        int index = 0;
        String[] stringArray = linkerOptions;
        int n = linkerOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.contains("EXPORT_NAME=")) {
                linkerOptions[index] = option.replace("ModuleName", name);
                break;
            }
            ++index;
            ++n2;
        }
    }

    private static void addBuildOptions(IConfiguration config, WasmSample.BuildConfiguration wasmBuildConfig) {
        if (config == null || wasmBuildConfig == null) {
            return;
        }
        ITool[] iToolArray = config.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            String[] stringArray = new String[]{"org.tizen.web.tv.sec.wasm.builder.compiler.c.option.misc.other", "gnu.c.link.option.ldflags", "org.tizen.web.tv.sec.wasm.builder.compiler.cpp.option.misc.other", "gnu.cpp.link.option.flags"};
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] optionsToAppend;
                String optionId = stringArray[n4];
                IOption option = tool.getOptionById(optionId);
                if (option != null && (optionsToAppend = wasmBuildConfig.getFlagsForCdtToolOptionId(optionId)).length != 0) {
                    if (optionId.equals("gnu.c.link.option.ldflags") || optionId.equals("gnu.cpp.link.option.flags")) {
                        ProjectFactory.updateModuleExportName(config.getOwner().getName(), optionsToAppend);
                    }
                    try {
                        Object newOptions = ProjectFactory.newOptions(option, optionsToAppend);
                        if (newOptions != null) {
                            if (newOptions instanceof String) {
                                ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)((String)newOptions));
                            } else if (newOptions instanceof String[]) {
                                ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])((String[])newOptions));
                            }
                        }
                    }
                    catch (BuildException e) {
                        System.err.println("Error when trying to get option " + optionId + " value type.");
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void setBuildSpec(IProjectDescription desc) {
        ICommand[] commandsArray = desc.getBuildSpec();
        Stream<ICommand> commands = Arrays.stream(commandsArray);
        if (!commands.anyMatch(cmd -> cmd.getBuilderName().equals("org.eclipse.cdt.managedbuilder.core.genmakebuilder"))) {
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.cdt.managedbuilder.core.genmakebuilder");
            command.setBuilding(15, true);
            command.setBuilding(6, true);
            command.setBuilding(10, true);
            command.setBuilding(9, false);
            ICommand[] newCommands = (ICommand[])Stream.concat(Arrays.stream(new ICommand[]{command}), Arrays.stream(commandsArray)).toArray(ICommand[]::new);
            desc.setBuildSpec(newCommands);
        }
    }

    public static IProject createProject(IProjectData projectData, IProgressMonitor monitor) throws CoreException, BuildException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreatingWasmProject, (int)100);
        IProject project = ProjectFactory.createBaseProject(projectData.getName(), projectData.getPath(), projectData.getSampleData().getLanguage(), (IProgressMonitor)progress.split(45));
        ProjectFactory.createProjectContent(projectData, (IProgressMonitor)progress.split(10));
        WasmPreferences.storeEmscriptenCachePath((IProject)project, (String)projectData.getEmscriptenConfigData().getCacheDirPath(), (IProgressMonitor)progress.split(5));
        WasmPreferences.storeEmscriptenConfigPath((IProject)project, (String)projectData.getEmscriptenConfigData().getConfigFilePath(), (IProgressMonitor)progress.split(5));
        ProjectFactory.addManagedBuilder(project, projectData, (IProgressMonitor)progress.split(25));
        project.refreshLocal(2, (IProgressMonitor)progress.split(10));
        return project;
    }
}

