/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.builder;

import java.util.logging.Logger;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public abstract class SourceMapOptionUtils {
    private static final String C_LINKER_SOURCEMAP_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.link.c.option.general.sourcemap";
    private static final String CC_LINKER_SOURCEMAP_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.link.cpp.option.general.sourcemap";
    private static final String C_LINKER_SOURCEMAP_HOST_IP_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.link.c.option.general.sourcemap.host_ip";
    private static final String CC_LINKER_SOURCEMAP_HOST_IP_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.link.cpp.option.general.sourcemap.host_ip";
    private static final Logger logger = Logger.getLogger(SourceMapOptionUtils.class.getPackage().getName());

    public static IOption getSourceMapOption(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration configuration = info.getDefaultConfiguration();
        return SourceMapOptionUtils.getSourceMapOption(configuration);
    }

    public static IOption getSourceMapHostIpOption(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration configuration = info.getDefaultConfiguration();
        return SourceMapOptionUtils.getSourceMapHostIpOption(configuration);
    }

    private static IOption getSourceMapOption(IConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        ITool targetTool = configuration.calculateTargetTool();
        return targetTool.getOptionBySuperClassId(SourceMapOptionUtils.getSourceMapOptionIdForTool(targetTool));
    }

    private static IOption getSourceMapHostIpOption(IConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        ITool targetTool = configuration.calculateTargetTool();
        return targetTool.getOptionBySuperClassId(SourceMapOptionUtils.getSourceMapHostIpOptionIdForTool(targetTool));
    }

    public static boolean getOptionValue(IOption option) {
        try {
            return option != null && option.getBooleanValue();
        }
        catch (BuildException exception) {
            logger.warning("Error during reading source map option: " + (Object)((Object)exception));
            return false;
        }
    }

    private static String getSourceMapOptionIdForTool(ITool targetTool) {
        if (targetTool == null) {
            return null;
        }
        int natureFilter = targetTool.getNatureFilter();
        switch (natureFilter) {
            case 0: {
                return C_LINKER_SOURCEMAP_OPTION_ID;
            }
            case 1: {
                return CC_LINKER_SOURCEMAP_OPTION_ID;
            }
        }
        logger.warning("Unknown nature filter: " + natureFilter);
        return "";
    }

    private static String getSourceMapHostIpOptionIdForTool(ITool targetTool) {
        if (targetTool == null) {
            return null;
        }
        int natureFilter = targetTool.getNatureFilter();
        switch (natureFilter) {
            case 0: {
                return C_LINKER_SOURCEMAP_HOST_IP_OPTION_ID;
            }
            case 1: {
                return CC_LINKER_SOURCEMAP_HOST_IP_OPTION_ID;
            }
        }
        logger.warning("Unknown nature filter: " + natureFilter);
        return "";
    }
}

