/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.tizenwizardadditions;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.ui.wizards.project.template.IToolChainExtension;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.TVSupportContainer;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.ToolchainWizardPage;

public class ToolchainExtension
implements IToolChainExtension {
    private static final boolean IS_WASM_AVAILABLE_SAMPLE = true;
    private static final boolean IS_WASM_AVAILABLE_TEMPLATE = true;
    private static ToolchainWizardPage samplePage = null;
    private static ToolchainWizardPage templatePage = null;
    private static IToolchainPageSettings sampleSettings = new IToolchainPageSettings(){

        @Override
        public boolean isWASMEnabled() {
            if (tvSampleSupportContainer == null) {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("TV sample support container is missing in toolchain wizard page");
                return false;
            }
            return tvSampleSupportContainer.isWasmSelected();
        }

        @Override
        public void setWASMEnabled(boolean enabled) {
            if (samplePage == null) {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Sample page is missing in toolchain wizard page");
                return;
            }
            samplePage.updatePage(this);
        }
    };
    private static IToolchainPageSettings templateSettings = new IToolchainPageSettings(){

        @Override
        public boolean isWASMEnabled() {
            if (tvTemplateSupportContainer == null) {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("TV template support container is missing in toolchain wizard page");
                return false;
            }
            return tvTemplateSupportContainer.isWasmSelected();
        }

        @Override
        public void setWASMEnabled(boolean enabled) {
            if (templatePage == null) {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Template page is missing in toolchain wizard page");
                return;
            }
            templatePage.updatePage(this);
        }
    };
    private static TVSupportContainer tvSampleSupportContainer = null;
    private static TVSupportContainer tvTemplateSupportContainer = null;

    public org.tizen.common.ui.wizards.project.template.ToolchainWizardPage getToolchainPage(IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                samplePage = new ToolchainWizardPage();
                return samplePage;
            }
            case TEMPLATE: {
                templatePage = new ToolchainWizardPage();
                return templatePage;
            }
        }
        Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Received unknown tizen project type");
        return null;
    }

    public boolean getToolchainPageEnabled(IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                return sampleSettings.isWASMEnabled();
            }
            case TEMPLATE: {
                return templateSettings.isWASMEnabled();
            }
        }
        Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Received unknown tizen project type");
        return false;
    }

    public void implementTVContainer(Composite container, IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                tvSampleSupportContainer = new TVSupportContainer(container, sampleSettings, true);
                break;
            }
            case TEMPLATE: {
                tvTemplateSupportContainer = new TVSupportContainer(container, templateSettings, true);
                break;
            }
            default: {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Received unknown tizen project type");
            }
        }
    }

    public Map<IFile, Boolean> performFinish(IProject project, IProgressMonitor monitor, IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                if (!sampleSettings.isWASMEnabled()) break;
                samplePage.performWasmFinish(project);
                break;
            }
            case TEMPLATE: {
                if (!templateSettings.isWASMEnabled()) break;
                templatePage.performWasmFinish(project);
                break;
            }
            default: {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Received unknown tizen project type");
            }
        }
        return new HashMap<IFile, Boolean>();
    }
}

