/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.sdb.command.message.CommandErrorException;
import org.tizen.common.sdb.command.message.CommandErrorType;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.tv.sec.launch.WASAppInfo;
import org.tizen.web.tv.sec.launch.util.SecTVCommandLauncher;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.step.UnInstallStep;

public class SecTVWASUnInstallStep
extends UnInstallStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVWASUnInstallStep.class);
    protected SecTVCommandLauncher secTVlauncher;
    protected WASAppInfo wasAppInfo = null;

    private static void dumpLogs(String fileName, String str) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            System.out.println("exception occurred" + e);
        }
    }

    protected String getLaunchCommand() throws Exception {
        String cmd = null;
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        System.out.println("Calling VD_UNINSTALL_CMD_WITH_WASAPPID command...");
        SecTVWASUnInstallStep.dumpLogs("F:\\2023\\TizenStudioDoc\\tvExtension.log", "Calling VD_UNINSTALL_CMD_WITH_WASAPPID command...\n");
        if (this.resource != null) {
            cmd = secTVWRTCommandUtil.getCommand("VD_UNINSTALL_COMMAND_WITH_WASAPPID", this.wasAppInfo.getWasAppID(), this.resource);
        }
        return cmd;
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        String msg;
        String msg2;
        UserLogger.start((String)"web.launch", (String)".uninstall");
        this.preExecuteStep(ctx);
        if (!this.isInstalled) {
            this.notifier.notifyContents(Messages.getSuccessMessage((String)Messages.UNINSTALL_PACKAGE), this.getWorkCount(100));
            UserLogger.end((String)".uninstall");
            return;
        }
        String cmd = this.getLaunchCommand();
        int timeout = this.secTVlauncher.getTimeout() * 1000;
        String failMessage = Messages.getFailMessage((String)name);
        try {
            SdbCommand sdbCommand = new SdbCommand(this.secTVlauncher.getDevice(), (ITizenConsoleManager)TizenWebConsole.getInstance(), (CommandOutputReceiver)new PkgCmdReceiver((ITizenConsoleManager)TizenWebConsole.getInstance()));
            sdbCommand.runCommand(cmd, (CommandErrorType)new PkgcmdErrorType(), timeout);
        }
        catch (TimeoutException timeoutException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_SYNCSERVICE_CONNECTION_TIMEOUT));
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(NLS.bind((String)Messages.SDB_TIMEOUT_EXCEPTION, (Object)timeout)), (TizenWebNotifier[])new TizenWebNotifier[]{this.notifier});
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_REJECT));
            msg2 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg2), (TizenWebNotifier[])new TizenWebNotifier[]{this.notifier});
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_UNRESPONSE));
            msg2 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg2), (TizenWebNotifier[])new TizenWebNotifier[]{this.notifier});
        }
        catch (CommandErrorException commandErrorException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_ERROR));
            String cfr_ignored_0 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
        }
        catch (IOException iOException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_IO));
            msg2 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg2), (TizenWebNotifier[])new TizenWebNotifier[]{this.notifier});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg), (TizenWebNotifier[])new TizenWebNotifier[]{this.notifier});
        }
        this.wasAppInfo = null;
        this.wasAppInfo = this.secTVlauncher.isInstalledWAS(this.resource);
        boolean bl = this.isInstalled = this.wasAppInfo != null;
        if (this.isInstalled) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_STEPUNINSTALL_FAIL;
            logger.error(this.makeErrorDescription(code));
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + code.getDescription() + " " + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort((String)Messages.getFailMessage((String)Messages.UNINSTALL_PACKAGE), (Throwable)new TizenWebIDEException(msg), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        ctx.setValue((Object)"widget installation", (Object)this.isInstalled);
        this.notifier.notifyContents(NLS.bind((String)Messages.UNINSTALLED_PACKAGE, (Object)this.resource.getAppinfo().getAppID()), this.getWorkCount(100));
        UserLogger.end((String)"web.launch", (String)".uninstall");
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String failMessage = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        String msg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        this.secTVlauncher = (SecTVCommandLauncher)((Object)ctx.getValue((Object)"command launcher"));
        if (this.secTVlauncher == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER));
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE));
            TizenWebIDEException.abort((String)failMessage, (Throwable)new TizenWebIDEException(msg), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.wasAppInfo = this.secTVlauncher.isInstalledWAS(this.resource);
        this.isInstalled = this.wasAppInfo != null;
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }
}

