/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.preferences.toolchain;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

public class ToolchainVerifier {
    private static final String[] binaries = new String[]{"emcc", "em++"};

    public static boolean verify(String toolchainPath) {
        String[] stringArray = binaries;
        int n = binaries.length;
        int n2 = 0;
        while (n2 < n) {
            String binary = stringArray[n2];
            String filePath = String.valueOf(toolchainPath) + File.separator + binary;
            if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0]) || !ToolchainVerifier.isExecutableFile(new String[]{filePath, "--version"})) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isExecutableFile(String[] command) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            if (!process.waitFor(1L, TimeUnit.SECONDS)) {
                process.destroyForcibly();
            }
            return process.exitValue() == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }
}

