/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.zimlaunch.step.KillStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.PortUtil;

public class SecTVKillStep
extends KillStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVKillStep.class);

    protected String getLaunchCommand() throws Exception {
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = secTVWRTCommandUtil.getCommand("KILL_COMMAND", null, this.resource);
        return cmd;
    }

    protected String getWasKillCommand() throws Exception {
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = secTVWRTCommandUtil.getCommand("WAS_KILL_COMMAND", null, this.resource);
        return cmd;
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        String cmd;
        UserLogger.start((String)"web.launch", (String)".kill");
        this.preExecuteStep(ctx);
        int code = 0;
        if (!this.isInstalled || !this.launcher.isRunningWidget(this.resource)) {
            logger.debug(Messages.getSuccessMessage((String)Messages.STEP_KILL), (Object)this.getWorkCount(100));
            UserLogger.end((String)"web.launch", (String)".kill");
            return;
        }
        this.handleCancelEvent(this.notifier, (IProgressMonitor)this.notifier.getMonitor());
        int oldlport = PortUtil.getInstance().getLocalPort(this.device.getSerialNumber(), this.appID);
        int oldrport = PortUtil.getInstance().getRemotePort(this.device.getSerialNumber(), this.appID);
        if (oldlport > 0 && oldrport > 0) {
            this.launcher.removeForward(this.appID, oldlport, oldrport);
        }
        if ((code = this.launcher.runCommand(cmd = this.getLaunchCommand(), true)) != 0) {
            String wasKillcmd = this.getWasKillCommand();
            this.launcher.runCommand(wasKillcmd, true);
        }
        this.handleCancelEvent(this.notifier, (IProgressMonitor)this.notifier.getMonitor());
        logger.debug(Messages.getSuccessMessage((String)Messages.STEP_KILL));
        UserLogger.end((String)"web.launch", (String)".kill");
    }
}

