/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.devicemanagerextension;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.web.tv.sec.launch.command.SdbCmdSelector;

public class InstalledWebAppsListDlg
extends JFrame {
    private static final long serialVersionUID = 1L;
    static IDevice connectedDevice;
    static JLabel label;
    private static JPanel panel;
    private static JTextArea txtArea;
    StringBuffer getInstalledWebAppsListResult = null;
    StringBuffer getWASInstalledWebAppsListResult = null;
    static String FILENAME;
    static InstalledWebAppsListDlg appList;
    static int isClosed;

    static {
        panel = null;
        txtArea = null;
        FILENAME = "logger.txt";
        isClosed = 0;
    }

    protected InstalledWebAppsListDlg() {
        this.createWebAppListUI();
    }

    public void logger(String str) {
        BufferedWriter bw = null;
        OutputStreamWriter fw = null;
        try {
            try {
                String data = String.valueOf(str) + '\n';
                File file = new File(FILENAME);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fw = new FileWriter(file.getAbsoluteFile(), true);
                bw = new BufferedWriter(fw);
                bw.write(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setWASResult(String result) {
        if (this.getWASInstalledWebAppsListResult == null) {
            this.getWASInstalledWebAppsListResult = new StringBuffer();
        }
        this.getWASInstalledWebAppsListResult.append(result);
    }

    public MultiLineReceiver createWASAppResultMultiLineReceiver() {
        return new MultiLineReceiver(){
            String wasAppID = "";
            String appName = "";
            String appVersion = "";
            String tizenAppID = "";
            int index = 1;
            int matcherFindNumber = 0;

            public void processNewLines(String[] lines) {
                String result = "";
                String regx = "(app_id|app_title|app_version|app_tizen_id)(.*)=(.*)";
                Pattern pattern = Pattern.compile(regx);
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String cont = stringArray[n2];
                    Matcher matcher = pattern.matcher(cont);
                    String value = "";
                    while (matcher.find()) {
                        value = matcher.group(3).replaceAll("-", "").trim();
                        ++this.matcherFindNumber;
                        switch (this.matcherFindNumber) {
                            case 1: {
                                this.wasAppID = value;
                                break;
                            }
                            case 2: {
                                this.appName = value;
                                break;
                            }
                            case 3: {
                                this.appVersion = value;
                                break;
                            }
                            case 4: {
                                this.tizenAppID = value;
                                break;
                            }
                            default: {
                                value = "";
                            }
                        }
                    }
                    if (this.matcherFindNumber == 4) {
                        result = String.valueOf(result) + "[ " + this.index + " - " + this.appName + "]" + "\n";
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App Name", "", this.appName);
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App Version", "", this.appVersion);
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App ID - WAS", "", this.wasAppID);
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App ID - Tizen", "", this.tizenAppID);
                        int j = 0;
                        while (j <= 100) {
                            result = String.valueOf(result) + "-";
                            ++j;
                        }
                        result = String.valueOf(result) + "\n";
                        ++this.index;
                        this.matcherFindNumber = 0;
                    }
                    ++n2;
                }
                InstalledWebAppsListDlg.this.setWASResult(String.valueOf(result) + System.getProperty("line.separator"));
            }
        };
    }

    private boolean isWasAppListCmdSupported() {
        double productVer = 0.0;
        double wasAppListCmdSupportVer = 2.1;
        try {
            PlatformCapability platformCapabilityChecker = connectedDevice.getPlatformCapability();
            productVer = Double.parseDouble(platformCapabilityChecker.getProductVersion());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return productVer >= wasAppListCmdSupportVer;
    }

    public boolean isWASCMDApp(String appId, ArrayList<String> wasInstalledWebAppList) {
        boolean isWascmdApp = false;
        for (String widget : wasInstalledWebAppList) {
            if (!widget.matches(".*" + appId + ".*")) continue;
            isWascmdApp = true;
            break;
        }
        return isWascmdApp;
    }

    public ArrayList<String> getWASInstalledWebAppList() throws Exception {
        if (this.getWASInstalledWebAppsListResult == null) {
            this.getWASInstalledWebAppsListResult = new StringBuffer();
        } else {
            this.getWASInstalledWebAppsListResult.delete(0, this.getWASInstalledWebAppsListResult.capacity());
            this.getWASInstalledWebAppsListResult.setLength(0);
        }
        MultiLineReceiver receiver = this.createWASAppResultMultiLineReceiver();
        ArrayList<String> wasInstalledWebAppList = new ArrayList<String>();
        wasInstalledWebAppList.clear();
        String cmd = "0 vd_applist";
        connectedDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        String delim = System.getProperty("line.separator");
        String[] stringArray = StringUtil.split((String)this.getWASInstalledWebAppsListResult.toString(), (String)delim);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cont = stringArray[n2];
            txtArea.append(String.valueOf(cont) + '\n');
            wasInstalledWebAppList.add(cont);
            ++n2;
        }
        txtArea.setCaretPosition(0);
        return wasInstalledWebAppList;
    }

    public void setWRTResult(String result) {
        if (this.getInstalledWebAppsListResult == null) {
            this.getInstalledWebAppsListResult = new StringBuffer();
        }
        this.getInstalledWebAppsListResult.append(result);
    }

    private String getAppinstallCmdTypeValue(String appID) {
        String appinstallCmdTypeValue = "pkgcmd";
        ArrayList<String> wasInstalledWebAppList = null;
        if (this.isWasAppListCmdSupported()) {
            try {
                wasInstalledWebAppList = this.getWASInstalledWebAppList();
                if (wasInstalledWebAppList != null && !wasInstalledWebAppList.isEmpty() && this.isWASCMDApp(appID, wasInstalledWebAppList)) {
                    appinstallCmdTypeValue = "wascmd";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return appinstallCmdTypeValue;
    }

    public MultiLineReceiver getMultiLineReceiverForVer30Higher() {
        return new MultiLineReceiver(){
            String appName = "";
            String appID = "";
            int index = 1;
            int matcherFindNumber = 0;

            public void processNewLines(String[] lines) {
                String result = "";
                String regx = "\\'(.*?)\\'";
                Pattern pattern = Pattern.compile(regx);
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String cont = stringArray[n2];
                    Matcher matcher = pattern.matcher(cont);
                    String value = "";
                    while (matcher.find()) {
                        value = matcher.group(1);
                        ++this.matcherFindNumber;
                        switch (this.matcherFindNumber) {
                            case 1: {
                                this.appName = value;
                                break;
                            }
                            case 2: {
                                this.appID = value;
                                break;
                            }
                            default: {
                                value = "";
                            }
                        }
                    }
                    if (this.matcherFindNumber == 2) {
                        result = String.valueOf(result) + "[ " + this.index + " - " + this.appName + "]" + "\n";
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "Name", "", this.appName);
                        result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App ID", "", this.appID);
                        if (InstalledWebAppsListDlg.this.isWasAppListCmdSupported()) {
                            result = String.valueOf(result) + String.format("- %-35s : %3s %s%n", "App installation command type", "", InstalledWebAppsListDlg.this.getAppinstallCmdTypeValue(this.appID));
                        }
                        int j = 0;
                        while (j <= 100) {
                            result = String.valueOf(result) + "-";
                            ++j;
                        }
                        result = String.valueOf(result) + "\n";
                        ++this.index;
                        this.matcherFindNumber = 0;
                    }
                    ++n2;
                }
                InstalledWebAppsListDlg.this.setWRTResult(String.valueOf(result) + System.getProperty("line.separator"));
            }
        };
    }

    public MultiLineReceiver getMultiLineReceiverForVer24() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String cont = stringArray[n2];
                    String result = "";
                    String delim = " ";
                    int index = 0;
                    String[] stringArray2 = StringUtil.split((String)cont, (String)delim);
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block19: {
                            String str;
                            block18: {
                                str = stringArray2[n4];
                                if (index != 0) break block18;
                                int number = 0;
                                try {
                                    number = Integer.parseInt(str.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (number <= 0) break block19;
                            }
                            switch (index) {
                                case 0: {
                                    result = String.valueOf(result) + "[ " + str + " - ";
                                    break;
                                }
                                case 1: {
                                    result = String.valueOf(result) + str + " ]" + "\n";
                                    result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "Name", "", str);
                                    break;
                                }
                                case 2: {
                                    result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "Version", "", str);
                                    break;
                                }
                                case 3: {
                                    result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "GUID", "", str);
                                    break;
                                }
                                case 4: {
                                    result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "Package ID", "", str);
                                    break;
                                }
                                case 5: {
                                    result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "App ID", "", str);
                                    if (InstalledWebAppsListDlg.this.isWasAppListCmdSupported()) {
                                        result = String.valueOf(result) + String.format("- %-35s : %3s %s\n", "App installation command type", "", InstalledWebAppsListDlg.this.getAppinstallCmdTypeValue(str));
                                    }
                                    int j = 0;
                                    while (j <= 100) {
                                        result = String.valueOf(result) + "-";
                                        ++j;
                                    }
                                    break;
                                }
                            }
                            ++index;
                        }
                        ++n4;
                    }
                    InstalledWebAppsListDlg.this.setWRTResult(String.valueOf(result) + System.getProperty("line.separator"));
                    ++n2;
                }
            }
        };
    }

    public ArrayList<String> getInstalledWebAppList() throws Exception {
        if (this.getInstalledWebAppsListResult == null) {
            this.getInstalledWebAppsListResult = new StringBuffer();
        } else {
            this.getInstalledWebAppsListResult.delete(0, this.getInstalledWebAppsListResult.capacity());
            this.getInstalledWebAppsListResult.setLength(0);
        }
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)connectedDevice));
        MultiLineReceiver receiver = null;
        receiver = version.isSameOrBiggerThanVersion3() ? this.getMultiLineReceiverForVer30Higher() : this.getMultiLineReceiverForVer24();
        ArrayList<String> installedWebAppList = new ArrayList<String>();
        installedWebAppList.clear();
        SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(connectedDevice);
        String cmd = sdbCmdSelector.getCmd("QUERY_COMMAND", null);
        connectedDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        String delim = System.getProperty("line.separator");
        String[] stringArray = StringUtil.split((String)this.getInstalledWebAppsListResult.toString(), (String)delim);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cont = stringArray[n2];
            installedWebAppList.add(cont);
            txtArea.append(String.valueOf(cont) + '\n');
            ++n2;
        }
        txtArea.setCaretPosition(0);
        return installedWebAppList;
    }

    public void init() {
        try {
            if (this.isWasAppListCmdSupported()) {
                this.getWASInstalledWebAppList();
            } else {
                this.getInstalledWebAppList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createWebAppListUI() {
        this.setTitle("Installed WEB App List");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(100, 100, 440, 710);
        panel = new JPanel();
        this.setContentPane(panel);
        txtArea = new JTextArea(41, 37);
        panel.add(txtArea);
        txtArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(txtArea, 20, 30);
        panel.add(scroll);
        txtArea.setText("");
        this.init();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                appList.dispose();
                isClosed = 0;
            }
        });
    }

    public static void listWebAppList(IDevice device) {
        connectedDevice = device;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isClosed == 0) {
                    appList = new InstalledWebAppsListDlg();
                    isClosed = 1;
                }
            }
        });
    }
}

