/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.common.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.tv.sec.wasm.common.GeneralTools;
import org.tizen.web.tv.sec.wasm.common.SystemInfo;
import org.tizen.web.tv.sec.wasm.common.plugin.Messages;

public abstract class ProjectUtils {
    public static final String EM_CONFIG_VARIABLE_NAME = "EM_CONFIG";
    public static final String EM_CACHE_VARIABLE_NAME = "EM_CACHE";
    public static final String PATH_ENV_NAME = "PATH";
    public static final String TOOLS_PATH = ProjectUtils.getToolsPath().toString();

    public static boolean isWasmProject(IProject project) {
        boolean isWasmProject = false;
        try {
            isWasmProject = project.hasNature("org.tizen.web.tv.sec.wasm.common.plugin.WasmProjectNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isWasmProject;
    }

    public static IProject getTizenProject(IProject wasmProject) {
        IProject[] referencingProjects;
        if (wasmProject == null || !wasmProject.isOpen() || !ProjectUtils.isWasmProject(wasmProject)) {
            return null;
        }
        IProject[] iProjectArray = referencingProjects = wasmProject.getReferencingProjects();
        int n = referencingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject referencingProject = iProjectArray[n2];
            if (ProjectUtils.isWebTvTizenProject(referencingProject) && ProjectUtils.isWasmModuleInsideProject(wasmProject, referencingProject)) {
                return referencingProject;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isWasmModuleInsideProject(IProject wasmProject, IProject project) {
        String wasmProjectPath = ProjectUtils.getProjectBasePath(wasmProject);
        String projectFullPath = ProjectUtils.getProjectBasePath(project);
        return wasmProjectPath.contains(projectFullPath);
    }

    public static void toggleTizenProjectWasmNature(IProject project, ActionOnProject action) throws CoreException {
        ProjectUtils.toggleNature(project, action, "org.tizen.web.tv.sec.wasm.common.plugin.TizenProjectWasmNature");
    }

    public static void saveContentToFile(String filePath, String content) {
        GeneralTools.saveContentToFile((String)filePath, (String)content);
    }

    public static void resetEmscriptenConfig(ICConfigurationDescription configDescription, String emConfigPath, String emCachePath) throws CoreException {
        if (configDescription == null) {
            return;
        }
        if (emConfigPath == null || emConfigPath.isEmpty()) {
            return;
        }
        if (emCachePath == null || emCachePath.isEmpty()) {
            return;
        }
        IContributedEnvironment environment = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
        if (environment == null) {
            return;
        }
        String emscriptenPathContributions = GeneralTools.composePath((String[])GeneralTools.getPathContributionsSet((String)emConfigPath));
        if (emscriptenPathContributions == null) {
            throw new CoreException((IStatus)new Status(4, ProjectUtils.class.getPackage().getName(), String.valueOf(Messages.FailedToReadEmscriptenConfig) + emConfigPath));
        }
        environment.addVariable(EM_CONFIG_VARIABLE_NAME, emConfigPath, 1, null, configDescription);
        environment.addVariable(EM_CACHE_VARIABLE_NAME, emCachePath, 1, null, configDescription);
        String pathContribution = GeneralTools.composePath((String[])new String[]{TOOLS_PATH, emscriptenPathContributions});
        EnvironmentVariable pathVar = new EnvironmentVariable(PATH_ENV_NAME, pathContribution, 3, File.pathSeparator);
        environment.removeVariable(PATH_ENV_NAME, configDescription);
        environment.addVariable((IEnvironmentVariable)pathVar, configDescription);
    }

    public static void resetEmscriptenConfig(IProject project, IConfiguration configuration, String emConfigPath, String emCachePath) throws CoreException {
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        if (description == null) {
            System.err.println("Failed to get project description for project " + project.getName());
            return;
        }
        ICConfigurationDescription config = description.getConfigurationById(configuration.getId());
        ProjectUtils.resetEmscriptenConfig(config, emConfigPath, emCachePath);
        try {
            CoreModel.getDefault().setProjectDescription(project, description);
        }
        catch (CoreException e) {
            System.err.println("Failed to reset build environment from Emscripten config file: " + emConfigPath);
            e.printStackTrace();
        }
    }

    public static File getToolsPath() {
        File msys2Path;
        if (SystemInfo.isWindowsOs() && (msys2Path = Paths.get(InstallPathConfig.getToolsPath(), "msys2", "usr", "bin").toFile()).exists()) {
            return msys2Path;
        }
        return new File("");
    }

    public static void addReferencedProjects(IProject project, IProject[] referencedProjects, IProgressMonitor monitor) {
        try {
            IProjectDescription projectDescription = project.getDescription();
            IProject[] oldReferences = projectDescription.getReferencedProjects();
            IProject[] newReferences = Arrays.copyOf(oldReferences, oldReferences.length + referencedProjects.length);
            System.arraycopy(referencedProjects, 0, newReferences, oldReferences.length, referencedProjects.length);
            projectDescription.setReferencedProjects(newReferences);
            project.setDescription(projectDescription, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean existsProject(String projectName) {
        return ProjectUtils.getProjectByName(projectName) != null;
    }

    public static IProject getCurrentProject() {
        IProject project = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        project = ProjectUtils.getCurrentProject(selection);
        if (project == null) {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            project = ProjectUtils.getCurrentProject(editor);
        }
        return project;
    }

    public static IProject getCurrentProject(IEditorPart editor) {
        IFile file;
        if (editor == null) {
            return null;
        }
        IProject project = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            project = file.getProject();
        }
        return project;
    }

    public static IProject getCurrentProject(ISelection selection) {
        IResource resource;
        Object element;
        IProject project = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        return project;
    }

    public static IProject getProjectByName(String projectName) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (Objects.equals(project.getName(), projectName)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isWebTvTizenProject(IProject project) {
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        if (tizenProject == null) {
            return false;
        }
        return tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_APPLICATION;
    }

    public static void toggleNature(IProject project, ActionOnProject action, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> tempNatures = new ArrayList<String>(Arrays.asList(natures));
        if (tempNatures.contains(natureId)) {
            tempNatures.remove(natureId);
        } else {
            if (action != null && !action.doAction(project)) {
                return;
            }
            tempNatures.add(natureId);
        }
        description.setNatureIds(tempNatures.toArray(new String[0]));
        project.setDescription(description, null);
    }

    public static String getProjectBasePath(IProject project) {
        return project.getLocation().toOSString();
    }

    public static Document parseFile(File file) {
        Document moduleDoc = null;
        try {
            moduleDoc = Jsoup.parse((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return moduleDoc;
    }

    public static interface ActionOnProject {
        public boolean doAction(IProject var1);
    }
}

