/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.tizenwizardadditions;

import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.IToolchainContent;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.Messages;

public class ToolchainWizardPage
extends org.tizen.common.ui.wizards.project.template.ToolchainWizardPage {
    private static final String PAGE_TITLE = Messages.ToolchainWizardPage_SELECT_TOOLCHAIN_TEXT;
    private Composite wasmComposite;
    private Label errorLabel;
    private final IToolchainContent wasmContent = this.getToolchainContentFromExtension();
    private boolean wasmToolchainCompleted = true;

    protected ToolchainWizardPage() {
        super(PAGE_TITLE);
        if (this.wasmContent != null) {
            this.wasmContent.setEnableToolchainConfirmation(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean wasmToolchainSettingComplete) {
                    ToolchainWizardPage.this.wasmToolchainCompleted = wasmToolchainSettingComplete;
                    ToolchainWizardPage.this.checkToolchainsCompletion();
                }
            });
        }
    }

    public void checkToolchainsCompletion() {
        this.setPageComplete(this.wasmToolchainCompleted);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBounds(parent.getBounds());
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setForeground(SWTResourceManager.getColor(3));
        this.errorLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        if (this.wasmContent != null) {
            this.wasmComposite = new Composite(container, 0);
            this.wasmComposite.setLayout((Layout)new GridLayout(1, false));
            GridData gd_wasmComposite = new GridData(4, 128, true, true, 1, 1);
            this.wasmComposite.setLayoutData((Object)gd_wasmComposite);
            this.wasmContent.implementContent(this.wasmComposite, null);
        }
    }

    private IToolchainContent getToolchainContentFromExtension() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.tizen.web.tv.sec.wasm.tizenwizardadditions.wizard_toolchain_content");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj = element.createExecutableExtension("toolchainContent");
                if (obj instanceof IToolchainContent) {
                    return (IToolchainContent)obj;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public void performWasmFinish(IProject project) {
        if (this.wasmContent != null) {
            this.wasmContent.performFinish(project, true);
        }
    }

    public void updatePage(IToolchainPageSettings settings) {
        if (this.wasmContent != null) {
            this.wasmComposite.setVisible(settings.isWASMEnabled());
            this.wasmToolchainCompleted = !settings.isWASMEnabled();
        }
    }
}

