/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.tizenwizardadditions;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.wasm.tizenwizardadditions.Messages;

public class TVSupportContainer {
    private static final String WASM_LABEL = Messages.TVSupportContainer_WASM_CHECKBOX_TEXT;
    private final IToolchainPageSettings settings;
    private final boolean wasmAvailable;
    private boolean wasmSelected;
    private final Composite tvContainer;
    private Button wasmButton;

    public TVSupportContainer(Composite container, IToolchainPageSettings settings, boolean wasmAvailable) {
        this.tvContainer = container;
        this.settings = settings;
        this.wasmAvailable = wasmAvailable;
        this.wasmButton = null;
        this.wasmSelected = false;
        this.implementContainer();
    }

    private void implementContainer() {
        if (this.wasmAvailable) {
            this.wasmButton = new Button(this.tvContainer, 32);
            this.wasmButton.setText(WASM_LABEL);
            this.wasmButton.addSelectionListener(new SelectionListener(){

                private void updateWasmSelection(boolean selected) {
                    TVSupportContainer.this.wasmSelected = selected;
                    TVSupportContainer.this.settings.setWASMEnabled(TVSupportContainer.this.wasmSelected);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.updateWasmSelection(TVSupportContainer.this.wasmButton.getSelection());
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.updateWasmSelection(TVSupportContainer.this.wasmButton.getSelection());
                }
            });
        }
        this.tvContainer.redraw();
    }

    public boolean isWasmSelected() {
        return this.wasmSelected;
    }
}

