/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.usage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.web.tv.sec.util.IOUtil;

public class RemoteLogger {
    protected static final Logger logger = LoggerFactory.getLogger(RemoteLogger.class);
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String LOG_SCRIPT_PATH = "/cgi-bin/idelog.pl";
    private static final String URL_TITLE = "URL: ";
    private static final String LOG_SCRIPT_URL = RemoteLogger.getLogScriptURL();
    private static long START_TIME = 0L;
    private static long STOP_TIME = 0L;
    private static final String SDK_TYPE = "public";

    private static String getLogScriptURL() {
        String path;
        block9: {
            path = String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "log-server.conf";
            BufferedReader br = null;
            try {
                String sCurrentLine;
                br = new BufferedReader(new FileReader(path));
                while ((sCurrentLine = br.readLine()) != null) {
                    if (!sCurrentLine.startsWith(URL_TITLE)) continue;
                    path = new String(sCurrentLine.substring(URL_TITLE.length()));
                    int from = 0;
                    from = path.indexOf("//");
                    if ((from = path.indexOf(47, from + 2)) >= 0) {
                        path = path.substring(0, from);
                    }
                    path = String.valueOf(path) + LOG_SCRIPT_PATH;
                    break;
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage());
                path = "";
                IOUtil.tryClose(br);
                break block9;
            }
            catch (IndexOutOfBoundsException e) {
                try {
                    logger.warn(e.getMessage());
                    path = "";
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(br);
                    throw throwable;
                }
                IOUtil.tryClose(br);
                break block9;
            }
            IOUtil.tryClose(br);
        }
        return path;
    }

    private static void log(String msg) {
        if (msg.equals(START)) {
            START_TIME = System.currentTimeMillis();
            return;
        }
        if (msg.equals(STOP)) {
            STOP_TIME = System.currentTimeMillis();
            InputStreamReader in = null;
            BufferedReader br = null;
            HttpURLConnection conn = null;
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                if (LOG_SCRIPT_URL.equals("")) {
                    return;
                }
                try {
                    String line;
                    URL url = new URL(String.valueOf(LOG_SCRIPT_URL) + "?d=" + RemoteLogger.getRuntimeDuration() + "&c=" + SDK_TYPE);
                    conn = (HttpURLConnection)url.openConnection();
                    StringBuffer sb = new StringBuffer();
                    in = new InputStreamReader((InputStream)conn.getContent());
                    br = new BufferedReader(in);
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                START_TIME = 0L;
                STOP_TIME = 0L;
            }
        }
    }

    public static void sendStart() {
        RemoteLogger.log(START);
    }

    public static void sendStop() {
        RemoteLogger.log(STOP);
    }

    public static int getRuntimeDuration() {
        int minute = 0;
        long duration = (STOP_TIME - START_TIME) / 1000L;
        minute = (int)(duration / 60L);
        if (minute < 0) {
            minute = 0;
        }
        return minute;
    }
}

