/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.project;

import org.tizen.web.tv.sec.wasm.common.DeepCloneable;
import org.tizen.web.tv.sec.wasm.common.GeneralTools;
import org.tizen.web.tv.sec.wasm.common.NativeLanguage;
import org.tizen.web.tv.sec.wasm.project.WasmModuleLayout;
import org.tizen.web.tv.sec.wasm.project.WasmSamples;

public class WasmSample
implements DeepCloneable<WasmSample> {
    public static final String WASM_C_COMPILER_OTHER_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.compiler.c.option.misc.other";
    public static final String WASM_CPP_COMPILER_OTHER_OPTION_ID = "org.tizen.web.tv.sec.wasm.builder.compiler.cpp.option.misc.other";
    public static final String GNU_C_LINKER_FLAGS_OPTION_ID = "gnu.c.link.option.ldflags";
    public static final String GNU_CPP_LINKER_FLAGS_OPTION_ID = "gnu.cpp.link.option.flags";
    private final String name;
    private final String description;
    private final NativeLanguage language;
    private final WasmModuleLayout layout;
    private final WasmSamples.FilePaths[] filesPaths;
    private final BuildConfiguration[] buildConfigurations;

    public WasmSample(String name, String description, NativeLanguage language, WasmModuleLayout layout, WasmSamples.FilePaths[] sampleFilesPaths, BuildConfiguration[] buildConfigurations) {
        this.name = name;
        this.description = description;
        this.language = language;
        this.layout = layout;
        this.filesPaths = sampleFilesPaths;
        this.buildConfigurations = buildConfigurations;
    }

    public WasmSample(WasmSample other) {
        this.name = new String(other.name);
        this.description = new String(other.description);
        this.language = other.language;
        this.layout = other.layout == null ? null : new WasmModuleLayout(other.layout);
        this.filesPaths = (WasmSamples.FilePaths[])GeneralTools.deepCopy((DeepCloneable[])other.filesPaths);
        this.buildConfigurations = (BuildConfiguration[])GeneralTools.deepCopy((DeepCloneable[])other.buildConfigurations);
    }

    public WasmSample deepClone() {
        return new WasmSample(this);
    }

    public WasmSample(WasmSample other, WasmModuleLayout layout) {
        this.name = other.getName();
        this.description = other.getDescription();
        this.language = other.getLanguage();
        this.layout = layout;
        this.filesPaths = other.getSampleFilesPaths();
        this.buildConfigurations = other.getBuildConfigurations();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public NativeLanguage getLanguage() {
        return this.language;
    }

    public WasmModuleLayout getLayout() {
        return this.layout;
    }

    public WasmSamples.FilePaths[] getSampleFilesPaths() {
        return this.filesPaths;
    }

    public BuildConfiguration[] getBuildConfigurations() {
        return this.buildConfigurations;
    }

    public BuildConfiguration getBuildConfiguration(String name) {
        if (name == null || this.buildConfigurations == null) {
            return null;
        }
        BuildConfiguration[] buildConfigurationArray = this.buildConfigurations;
        int n = this.buildConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            BuildConfiguration configuration = buildConfigurationArray[n2];
            if (configuration.getName().equals(name)) {
                return configuration;
            }
            ++n2;
        }
        return null;
    }

    public static class BuildConfiguration
    implements DeepCloneable<BuildConfiguration> {
        private final String name;
        private final String[] cCompilerFlags;
        private final String[] cppCompilerFlags;
        private final String[] linkerFlags;

        public BuildConfiguration(String name, String[] cCompilerFlags, String[] cppCompilerFlags, String[] linkerFlags) {
            this.name = name;
            this.cCompilerFlags = cCompilerFlags;
            this.cppCompilerFlags = cppCompilerFlags;
            this.linkerFlags = linkerFlags;
        }

        public BuildConfiguration(BuildConfiguration other) {
            this.name = new String(other.name);
            this.cCompilerFlags = GeneralTools.deepCopy((String[])other.cCompilerFlags);
            this.cppCompilerFlags = GeneralTools.deepCopy((String[])other.cppCompilerFlags);
            this.linkerFlags = GeneralTools.deepCopy((String[])other.linkerFlags);
        }

        public BuildConfiguration deepClone() {
            return new BuildConfiguration(this);
        }

        public String getName() {
            return this.name;
        }

        public String[] getcCompilerFlags() {
            return this.cCompilerFlags;
        }

        public String[] getCppCompilerFlags() {
            return this.cppCompilerFlags;
        }

        public String[] getLinkerFlags() {
            return this.linkerFlags;
        }

        public String[] getFlagsForCdtToolOptionId(String optionId) {
            switch (optionId) {
                case "org.tizen.web.tv.sec.wasm.builder.compiler.cpp.option.misc.other": {
                    return this.getCppCompilerFlags();
                }
                case "org.tizen.web.tv.sec.wasm.builder.compiler.c.option.misc.other": {
                    return this.getcCompilerFlags();
                }
                case "gnu.cpp.link.option.flags": 
                case "gnu.c.link.option.ldflags": {
                    return this.getLinkerFlags();
                }
            }
            return new String[0];
        }
    }
}

