/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.builder;

import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.web.tv.sec.wasm.builder.SourceMapOptionUtils;
import org.tizen.web.tv.sec.wasm.builder.SourceMapServerPool;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;

public class SourceMapLaunchListener
implements ILaunchListener {
    private static final Logger logger = Logger.getLogger(SourceMapLaunchListener.class.getPackage().getName());
    private static final String invalidIp = "0.0.0.0";
    private static final String privateNetworkIp = "10.255.255.255";
    private final SourceMapServerPool serverPool = new SourceMapServerPool();

    public SourceMapLaunchListener() {
        Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunches()).forEach(this::launchAdded);
    }

    public void launchAdded(ILaunch launch) {
        Arrays.stream(SourceMapLaunchListener.getLaunchingSubprojects(launch)).filter(ProjectUtils::isWasmProject).forEach(project -> this.handleProjectLaunch((IProject)project, launch));
    }

    private static IProject getLaunchingProject(ILaunch launch) {
        try {
            String projectName = launch.getLaunchConfiguration().getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        catch (CoreException exception) {
            logger.warning("Failed to get project: " + (Object)((Object)exception));
            return null;
        }
    }

    private static IProject[] getLaunchingSubprojects(ILaunch launch) {
        IProject project = SourceMapLaunchListener.getLaunchingProject(launch);
        try {
            if (project != null) {
                return project.getReferencedProjects();
            }
        }
        catch (CoreException exception) {
            logger.warning("Failed to get subprojects: " + (Object)((Object)exception));
        }
        return new IProject[0];
    }

    private static boolean shouldHandleProject(IProject project) {
        IOption sourceMapOption = SourceMapOptionUtils.getSourceMapOption(project);
        return SourceMapOptionUtils.getOptionValue(sourceMapOption);
    }

    private void handleProjectLaunch(IProject project, ILaunch launch) {
        if (SourceMapLaunchListener.shouldHandleProject(project)) {
            this.startSourceMapDebugServer(project, launch);
        } else {
            this.serverPool.stopSourceMapServer(project);
        }
    }

    private static boolean isValidIp(String ip) {
        boolean valid = ip != null && !ip.isEmpty() && InetAddresses.isInetAddress((String)ip);
        logger.info("Validating the user specified IP: " + ip + (valid ? " - valid" : " - invalid"));
        return valid;
    }

    private static String getUserSetIp(IOption sourceMapHostIpOption) {
        try {
            String optionIp = sourceMapHostIpOption.getStringValue();
            if (!optionIp.isEmpty() && SourceMapLaunchListener.isValidIp(optionIp)) {
                return optionIp;
            }
        }
        catch (BuildException exception) {
            logger.warning("Failed to get user IP field of General linker options: " + (Object)((Object)exception));
        }
        return "";
    }

    private void startSourceMapDebugServer(IProject project, ILaunch launch) {
        String ip;
        IOption sourceMapOption = SourceMapOptionUtils.getSourceMapOption(project);
        IOption sourceMapHostIpOption = SourceMapOptionUtils.getSourceMapHostIpOption(project);
        Server debugServer = this.serverPool.startSourceMapDebugServer(project);
        if (debugServer == null) {
            return;
        }
        int debugServerPort = ((ServerConnector)debugServer.getConnectors()[0]).getLocalPort();
        logger.info("Server listening on port: " + debugServerPort + " is ready");
        String userSetIp = SourceMapLaunchListener.getUserSetIp(sourceMapHostIpOption);
        if (!userSetIp.isEmpty()) {
            ip = userSetIp;
            logger.info("Using the host IP set by the user: " + ip);
        } else {
            ip = SourceMapLaunchListener.getHostIp(launch);
            logger.info("Using automatically detected host IP: " + ip);
        }
        String cmd = String.format("--source-map-base http://%s:%d/CurrentBin/", ip, debugServerPort);
        logger.info("Setting command to: " + cmd);
        sourceMapOption.setCommand(cmd);
        try {
            project.build(10, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            logger.warning("Failed to rebuild the project: " + exception);
        }
    }

    private static String getHostIpViaSocket(ISocket socket, String deviceIp, int devicePort) {
        try {
            logger.info("Get host IP for device: " + deviceIp + ":" + devicePort + " via socket " + socket.getClass().getName());
            socket.connect(new InetSocketAddress(deviceIp != null ? deviceIp : privateNetworkIp, devicePort));
            String ip = socket.getLocalAddress().getHostAddress();
            logger.info("Got IP: " + ip);
            return ip;
        }
        catch (IOException exception) {
            logger.warning("Failed to get IP: " + exception);
            return invalidIp;
        }
    }

    private static String getHostIpForDeviceIp(String deviceIp, int devicePort) {
        String ip;
        try {
            ip = SourceMapLaunchListener.getHostIpViaSocket(new UdpSocket(), deviceIp, devicePort);
            if (!ip.equals(invalidIp)) {
                return ip;
            }
        }
        catch (SocketException exception) {
            logger.warning("Failed to get IP via datagram socket: " + exception);
        }
        logger.warning("Failed to get IP via datagram socket, trying tcp socket");
        ip = SourceMapLaunchListener.getHostIpViaSocket(new TcpSocket(), deviceIp, devicePort);
        if (!ip.equals(invalidIp)) {
            return ip;
        }
        logger.warning("Failed to get IP via tcp socket, trying getLocalHost");
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            logger.info("Host IP got from getLocalHost: " + ip);
            return ip;
        }
        catch (UnknownHostException unknownHostException) {
            logger.warning("All methods of getting the host IP failed");
            return invalidIp;
        }
    }

    private static String getHostIp(ILaunch launch) {
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (SourceMapLaunchListener.isLaunchTarget(device, launch)) {
                return SourceMapLaunchListener.getHostIpForDeviceIp(device.getIp(), device.getBasePort() + 1);
            }
            ++n2;
        }
        logger.warning("Failed to get host IP. No device connected?");
        return invalidIp;
    }

    private static boolean isLaunchTarget(IDevice device, ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            String deviceName = config.getAttribute("org.tizen.common.CONFIG_ATTR_DEVICE_NAME", "");
            String deviceSerial = config.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "");
            return device.isEmulator() && deviceName.equals(device.getDeviceName()) || deviceSerial.equals(device.getSerialNumber());
        }
        catch (CoreException exception) {
            logger.warning("Failed to get device options: " + (Object)((Object)exception));
            return false;
        }
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    private static interface ISocket {
        public void connect(SocketAddress var1) throws IOException;

        public InetAddress getLocalAddress();
    }

    private static class TcpSocket
    extends Socket
    implements ISocket {
        private static final int connectTimeoutMs = 10000;

        @Override
        public void connect(SocketAddress addr) throws IOException {
            super.connect(addr, 10000);
        }
    }

    private static class UdpSocket
    extends DatagramSocket
    implements ISocket {
    }
}

