/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;

public final class SourceMapServerPool {
    private static final Logger logger = Logger.getLogger(SourceMapServerPool.class.getPackage().getName());
    private Map<IPath, Server> servers = new HashMap<IPath, Server>();

    SourceMapServerPool() {
    }

    public Server startSourceMapDebugServer(IProject project) {
        IPath location = project.getLocation();
        Server oldServer = this.servers.get(location);
        if (oldServer != null) {
            return oldServer;
        }
        Server server = SourceMapServerPool.makeServer(location);
        try {
            server.start();
            this.servers.put(location, server);
            return server;
        }
        catch (Exception exception) {
            logger.warning("Failed to start server: " + exception);
            return null;
        }
    }

    private static Server makeServer(IPath location) {
        Server server = new Server(0);
        server.setHandler((Handler)SourceMapServerPool.makeContextHandler(location));
        return server;
    }

    private static ContextHandler makeContextHandler(IPath location) {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirAllowed(true);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/");
        contextHandler.setAllowNullPathInfo(true);
        contextHandler.setHandler((Handler)resourceHandler);
        contextHandler.setResourceBase(location.toString());
        contextHandler.clearAliasChecks();
        contextHandler.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        return contextHandler;
    }

    public void stopSourceMapServer(IProject project) {
        Server server = this.servers.remove(project.getLocation());
        if (server == null) {
            return;
        }
        try {
            server.stop();
            server.join();
            logger.info("Server: " + server + " stopped");
        }
        catch (Exception exception) {
            logger.warning("Failed to stop server: " + exception);
        }
    }
}

