/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class DeviceCapabilityValueDlg
extends TitleAreaDialog {
    List deviceCapabilityValueList;

    public DeviceCapabilityValueDlg(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(2144);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Device Capability Value");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        this.deviceCapabilityValueList = new List(container, 2818);
        this.deviceCapabilityValueList.setFont(SWTResourceManager.getFont("Consolas", 9, 0));
        this.deviceCapabilityValueList.setBounds(10, 10, 780, 282);
        Button btnNewButton = new Button(container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceCapabilityValueDlg.this.deviceCapabilityValueAllCopyToClipboard();
            }
        });
        btnNewButton.setBounds(621, 310, 169, 40);
        btnNewButton.setText("Copy to clipboard");
        this.deviceCapabilityValueList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 99) {
                    DeviceCapabilityValueDlg.this.deviceCapabilityValueListDataCopyToClipboard();
                }
            }

            public void keyReleased(KeyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 99) {
                    DeviceCapabilityValueDlg.this.deviceCapabilityValueListDataCopyToClipboard();
                }
            }
        });
        this.init();
        return area;
    }

    private void deviceCapabilityValueAllCopyToClipboard() {
        String[] installedWebAppsListInfo = this.deviceCapabilityValueList.getItems();
        String data = "";
        String[] stringArray = installedWebAppsListInfo;
        int n = installedWebAppsListInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            data = String.valueOf(data) + str + System.getProperty("line.separator");
            ++n2;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(data);
        clipboard.setContents(contents, null);
    }

    public void deviceCapabilityValueListDataCopyToClipboard() {
        String data = "";
        String[] stringArray = this.deviceCapabilityValueList.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            data = String.valueOf(data) + str + System.getProperty("line.separator");
            ++n2;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (data != null && !data.isEmpty()) {
            StringSelection contents = new StringSelection(data);
            clipboard.setContents(contents, null);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(806, 507);
    }

    private void init() {
        ArrayList<String> deviceCapabilityValueList = null;
        this.clearDeviceCapabilityValueList();
        deviceCapabilityValueList = this.getDeviceCapabilityValueList();
        this.setDeviceCapabilityValueItems(deviceCapabilityValueList);
    }

    private void clearDeviceCapabilityValueList() {
        this.deviceCapabilityValueList.removeAll();
    }

    private ArrayList<String> getDeviceCapabilityValueList() {
        ArrayList<String> deviceCapabilityValueList = new ArrayList<String>();
        IDevice device = ConnectionPlugin.getDefault().getCurrentDevice();
        String secureProtocol = "secure_protocol : ";
        String cpuArch = "cpu_arch : ";
        String sdkToolPath = "sdk_toolpath : ";
        String profileName = "profile_name : ";
        String vendorName = "vendor_name : ";
        String canLaunch = "can_launch : ";
        String platformVersion = "platform_version : ";
        String productVersion = "product_version : ";
        String appCmdSupport = "appcmd_support : ";
        if (device != null) {
            try {
                PlatformCapability platformCapabilityChecker = device.getPlatformCapability();
                secureProtocol = String.valueOf(secureProtocol) + platformCapabilityChecker.getSecureProtocol();
                cpuArch = String.valueOf(cpuArch) + platformCapabilityChecker.getCpuArch();
                sdkToolPath = String.valueOf(sdkToolPath) + platformCapabilityChecker.getSdkToolPath();
                profileName = String.valueOf(profileName) + platformCapabilityChecker.getProfileName();
                vendorName = String.valueOf(vendorName) + platformCapabilityChecker.getVendorName();
                canLaunch = String.valueOf(canLaunch) + platformCapabilityChecker.getCanLaunch();
                platformVersion = String.valueOf(platformVersion) + platformCapabilityChecker.getPlatformVersion();
                productVersion = String.valueOf(productVersion) + platformCapabilityChecker.getProductVersion();
                appCmdSupport = String.valueOf(appCmdSupport) + platformCapabilityChecker.getAppCmdSupport();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (SdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            deviceCapabilityValueList.add(secureProtocol);
            deviceCapabilityValueList.add(cpuArch);
            deviceCapabilityValueList.add(sdkToolPath);
            deviceCapabilityValueList.add(profileName);
            deviceCapabilityValueList.add(vendorName);
            deviceCapabilityValueList.add(canLaunch);
            deviceCapabilityValueList.add(platformVersion);
            deviceCapabilityValueList.add(productVersion);
            deviceCapabilityValueList.add(secureProtocol);
            deviceCapabilityValueList.add(appCmdSupport);
        }
        return deviceCapabilityValueList;
    }

    private void setDeviceCapabilityValueItems(ArrayList<String> data) {
        for (String cont : data) {
            this.addDeviceCapabilityValueItem(cont);
        }
    }

    private void addDeviceCapabilityValueItem(String data) {
        this.deviceCapabilityValueList.add(data);
    }
}

