/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.profile;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;

public class TizenProfileOperation {
    public static void tizenProjectCreationGenericProcess(IProject project) throws CoreException, IOException {
        TizenProfileOperation.tizenProjectCreationGenericProcess(project, InstallPathConfig.getLatestProfileInfo());
    }

    public static void tizenProjectCreationGenericProcess(IProject project, final ProfileInfo profileInfo) throws CoreException, IOException {
        Assert.notNull((Object)project);
        Assert.notNull((Object)profileInfo);
        AbstractProjectTemplateOperation tvProfileOperation = new AbstractProjectTemplateOperation(){

            public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
                Assert.notNull((Object)profileInfo);
                ProjectUtil.updateTizenProjectDescription((IProject)project, (ProfileInfo)profileInfo);
                return true;
            }
        };
        tvProfileOperation.setMainTask("Generate TV profile...");
        LinkedList<1> operations = new LinkedList<1>();
        operations.add(tvProfileOperation);
        operations.add(new DefaultNatureOperation());
        operations.add(tvProfileOperation);
        operations.add(new ContentAssistOperation());
        for (IProjectTemplateOperation iProjectTemplateOperation : operations) {
            if (iProjectTemplateOperation.execute(null, project, null)) continue;
            throw new OperationCanceledException();
        }
    }
}

