/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.add_wasm_module.wizard;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.Messages;
import org.tizen.web.tv.sec.wasm.add_wasm_module.wizard.NameAndLayoutPage;
import org.tizen.web.tv.sec.wasm.common.NativeLanguage;
import org.tizen.web.tv.sec.wasm.project.WasmSample;
import org.tizen.web.tv.sec.wasm.project.WasmSamples;

public class SampleSelectionPage
extends WizardPage {
    private static final String[] LANGUAGES = new String[]{NativeLanguage.CPP.toString(), NativeLanguage.C.toString()};
    private static final Map<String, WasmSample> SAMPLES = new WasmSamples().getSamples();
    private static final String[] SAMPLES_C = SampleSelectionPage.getSampleNames(NativeLanguage.C);
    private static final String[] SAMPLES_CPP = SampleSelectionPage.getSampleNames(NativeLanguage.CPP);
    private List samplesList = null;
    private StyledText descriptionText = null;
    private Button emptyRadio = null;
    private Button sampleRadio = null;
    private NameAndLayoutPage layoutPage = null;
    private WasmSample selectedSample = null;

    public SampleSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.SampleSelectionPage_Content);
        this.setDescription(Messages.SampleSelectionPage_SelectContent);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.layoutPage = (NameAndLayoutPage)this.getWizard().getPage("LayoutPage");
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Group moduleContentGroup = new Group(container, 0);
        GridData gd_container = new GridData(4, 4, true, true, 2, 1);
        gd_container.widthHint = 850;
        gd_container.heightHint = 350;
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 10;
        gl_container.horizontalSpacing = 10;
        gl_container.marginHeight = 5;
        gl_container.marginWidth = 10;
        moduleContentGroup.setLayout((Layout)gl_container);
        moduleContentGroup.setLayoutData((Object)gd_container);
        moduleContentGroup.setText(Messages.SampleSelectionPage_ModuleContent);
        Label languageLabel = new Label((Composite)moduleContentGroup, 0);
        languageLabel.setText(Messages.SampleSelectionPage_Language);
        final CCombo languageCombo = new CCombo((Composite)moduleContentGroup, 2048);
        languageCombo.setText(NativeLanguage.CPP.toString());
        languageCombo.setItems(LANGUAGES);
        languageCombo.setEditable(false);
        languageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SampleSelectionPage.this.actionOnLanguageChange(languageCombo.getText());
            }
        });
        Label separatorLabel = new Label((Composite)moduleContentGroup, 258);
        separatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sampleRadio = new Button((Composite)moduleContentGroup, 16);
        this.sampleRadio.setText(Messages.SampleSelectionPage_Sample);
        this.sampleRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SampleSelectionPage.this.sampleRadio.getSelection()) {
                    if (SampleSelectionPage.this.samplesList != null) {
                        SampleSelectionPage.this.samplesList.setItems(SampleSelectionPage.getLanguageSamples(languageCombo.getText()));
                        SampleSelectionPage.this.selectFirstSample();
                    }
                    SampleSelectionPage.this.enableOtherPagesControls(false);
                    SampleSelectionPage.this.checkPageCompleteAndUpdateDescription();
                }
            }
        });
        Label descriptionLabel = new Label((Composite)moduleContentGroup, 0);
        descriptionLabel.setText(Messages.SampleSelectionPage_Description);
        this.samplesList = new List((Composite)moduleContentGroup, 2048);
        this.samplesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selected = SampleSelectionPage.this.samplesList.getSelection();
                if (selected.length > 0) {
                    if (SampleSelectionPage.this.sampleRadio != null) {
                        SampleSelectionPage.this.sampleRadio.setSelection(true);
                        SampleSelectionPage.this.enableOtherPagesControls(false);
                    }
                    if (SampleSelectionPage.this.emptyRadio != null) {
                        SampleSelectionPage.this.emptyRadio.setSelection(false);
                    }
                    SampleSelectionPage.this.selectedSample = (WasmSample)SAMPLES.get(selected[0]);
                    SampleSelectionPage.this.checkPageCompleteAndUpdateDescription();
                }
            }
        });
        this.samplesList.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.samplesList.setItems(SampleSelectionPage.getLanguageSamples(NativeLanguage.CPP.toString()));
        this.descriptionText = new StyledText((Composite)moduleContentGroup, 2112);
        this.descriptionText.setText(Messages.SampleSelectionPage_descriptionText_text);
        this.descriptionText.setDoubleClickEnabled(false);
        this.descriptionText.setEnabled(false);
        this.descriptionText.setEditable(false);
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.emptyRadio = new Button((Composite)moduleContentGroup, 16);
        this.emptyRadio.setText(Messages.SampleSelectionPage_EmptyModule);
        this.emptyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SampleSelectionPage.this.emptyRadio.getSelection()) {
                    SampleSelectionPage.this.samplesList.deselectAll();
                    SampleSelectionPage.this.selectedSample = (WasmSample)SAMPLES.get("Empty" + languageCombo.getText());
                    SampleSelectionPage.this.enableOtherPagesControls(true);
                    SampleSelectionPage.this.checkPageCompleteAndUpdateDescription();
                }
            }
        });
    }

    private void selectFirstSample() {
        if (this.samplesList != null && this.samplesList.getItemCount() > 0) {
            this.samplesList.setSelection(0);
            this.selectedSample = SAMPLES.get(this.samplesList.getSelection()[0]);
        }
    }

    private static String[] getLanguageSamples(String language) {
        if (language.equals(NativeLanguage.C.toString())) {
            return SAMPLES_C;
        }
        if (language.equals(NativeLanguage.CPP.toString())) {
            return SAMPLES_CPP;
        }
        return new String[0];
    }

    private static String[] getSampleNames(NativeLanguage language) {
        ArrayList<String> sampleNames = new ArrayList<String>();
        for (WasmSample sample : SAMPLES.values()) {
            if (sample.getLanguage() != language || sample.getName().startsWith("Empty")) continue;
            sampleNames.add(sample.getName());
        }
        return sampleNames.toArray(new String[0]);
    }

    protected void actionOnLanguageChange(String language) {
        if (this.samplesList != null) {
            this.samplesList.setItems(SampleSelectionPage.getLanguageSamples(language));
        }
        this.selectedSample = null;
        if (this.sampleRadio != null && this.sampleRadio.getSelection()) {
            this.selectFirstSample();
        } else if (this.emptyRadio != null && this.emptyRadio.getSelection()) {
            this.selectedSample = SAMPLES.get("Empty" + language);
        }
        this.checkPageCompleteAndUpdateDescription();
    }

    private void checkPageCompleteAndUpdateDescription() {
        if (this.descriptionText == null) {
            return;
        }
        if (this.selectedSample != null) {
            this.descriptionText.setText(this.selectedSample.getDescription());
            this.setPageComplete(true);
        } else {
            this.descriptionText.setText(Messages.SampleSelectionPage_descriptionText_text);
            this.setPageComplete(false);
        }
    }

    public WasmSample getSelectedSample() {
        return new WasmSample(this.selectedSample);
    }

    private void enableOtherPagesControls(boolean enable) {
        if (this.layoutPage == null) {
            return;
        }
        this.layoutPage.enableLayoutControls(enable);
    }
}

