/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __CONTACT_DETAILS_H__
#define __CONTACT_DETAILS_H__

#include "common.h"

#include <contacts.h>


/**
 * @brief Toggles is_favourite value for person
 * @param[in]   person_id   ID of person
 * @return true if success, otherwise false
 */
bool sc_cdetails_toggle_favourites(int person_id);

/**
 * @brief Informs that person with ID @a person_id is exist in favourites list
 * @param[in]   person_id   ID of person
 * @return true if success, otherwise false
 */
bool sc_cdetails_is_favourite(int person_id);

/**
 * @brief Retrieves contact field value
 * @remark @a value MUST be destroyed with free() by you
 * @param[in]   field_type      Type of field: number, email
 * @param[in]   contact_id      ID of contact
 * @param[out]  value           Return value
 * @return true if success, otherwise false
 */
bool sc_cdetails_get_contact_val(sc_common_contact_fields field_type, int contact_id, char **value);

#endif //__CONTACT_DETAILS_H__
